/*
 * dia_RtCtrlSystemOperationTime_Reset.cpp
 *
 *  Created on: 21.11.2012
 *      Author: shw2abt
 */

// TTFis:\> DIA_REQ UDS 05 31 01 D0 10

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#include "dia_RtCtrlSystemOperationTime_Reset.h"

static tU8 sResultMapping[DIA_EN_RTCTRL_STATUS_COUNT] = {
      0xFF, // DIA_EN_RTCTRL_STATUS_UNKNOWN
      0xFF, // DIA_EN_RTCTRL_STATUS_IDLE
      0xFF, // DIA_EN_RTCTRL_STATUS_IN_PROGRESS
      0x00, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK
      0x01, // DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK
      0xFF, // DIA_EN_RTCTRL_STATUS_ABORTED
      0xFF  // DIA_EN_RTCTRL_STATUS_TIMED_OUT
};

//-----------------------------------------------------------------------------

dia_RtCtrlSystemOperationTime_Reset::dia_RtCtrlSystemOperationTime_Reset ( tVoid )
   : dia_Routine("dia_RtCtrlSystemOperationTime_Reset",
         DIA_C_U16_DID_RBCM_RTCTRL_RESET_SYSTEM_OPERATION_TIME,
         DIA_EN_RTCTRL_ID_SYSTEM_OPERATION_TIME_RESET,
         DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   dia_tclFnctTrace oTrace("dia_RtCtrlSystemOperationTime_Reset::dia_RtCtrlSystemOperationTime_Reset()");
}

//-----------------------------------------------------------------------------

dia_RtCtrlSystemOperationTime_Reset::~dia_RtCtrlSystemOperationTime_Reset ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_RtCtrlSystemOperationTime_Reset::~dia_RtCtrlSystemOperationTime_Reset !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-------------------------------------------------------------------------------

//tVoid
//dia_RtCtrlSystemOperationTime_Reset::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
//{
//   dia_tclFnctTrace trc("dia_RtCtrlSystemOperationTime_Reset::vProcessRequest");
//
//   tBool errorDetected = TRUE;
//
//   dia_ISpmTimerIntervall* pInterface = 0;
//   if ( querySysAdapterInterface<dia_ISpmTimerIntervall>(&pInterface) == DIA_SUCCESS )
//   {
//      if ( pInterface )
//      {
//         // TODO - Empfangene Daten auswerten
//
//         setSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
//         if ( pInterface->setSpmTimerIntervall(DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER, 0) == DIA_SUCCESS )
//         {
//            errorDetected = FALSE;
//         }
//      }
//   }
//
//   if ( errorDetected )
//   {
//      (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
//      DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
//      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
//   }
//}
//
////-----------------------------------------------------------------------------
//
//tVoid
//dia_RtCtrlSystemOperationTime_Reset::vOnSpmTimerReset ( tDiaResult success ){
//   dia_tclFnctTrace trc("dia_RtCtrlSystemOperationTime_Reset::vOnSpmTimerReset");
//
//   if (success == DIA_SUCCESS) {
//      (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
//
//      // Sending back the positive answer
//      DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::vOnSpmTimerReset SUCCESSFUL");
//      oDiagMsgBuffer().vSetPosResp();
//      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
////      oDiagMsgBuffer().vSetDataU8(DATA_START + 3, ((tU8) (timerIntervall)));
//
//      vResReadyAndQuit();
//   } else {
//      DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::vOnSpmTimerReset FAIL");
//      // Sending back the Negative answer
//      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
//   }
//}


//------------------------------------------------------------------------------

tDiaResult
dia_RtCtrlSystemOperationTime_Reset::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlSystemOperationTime_Reset::start()");
   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   dia_ISpmTimerIntervall* pInterface = OSAL_NULL;
   if (querySysAdapterInterface<dia_ISpmTimerIntervall>(&pInterface) == DIA_SUCCESS ) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_ISpmTimerIntervallListener>(this);

         if (pInterface->setSpmTimerIntervall(DIA_EN_SPM_TIMERINTERVALL_ID_OPERATION_COUNTER, 0 /*Reset*/) == DIA_SUCCESS ) {
            DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::start startOPTime SUCCESS.");
            // currently we only have a dummy implementation
            eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
            retCode = DIA_SUCCESS;
         } else {
            DIA_TR_ERR("dia_RtCtrlSystemOperationTime_Reset::start SEND TO SPM SERVER FAILED!!!!");
         }
      }
   } else {
      DIA_TR_ERR("dia_RtCtrlSystemOperationTime_Reset::start - diaResult FAILED!!!!");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RtCtrlSystemOperationTime_Reset::requestResult ( std::vector<tU8>& results ) // -> Zum Pollen
{
   dia_tclFnctTrace oTrace("dia_RtCtrlSystemOperationTime_Reset::requestResult()");
   tDiaResult retCode = DIA_E_SEQUENCE_ERROR;

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::requestResult --- 2");
      switch ( mStatus )
      {
      case DIA_EN_RTCTRL_STATUS_IN_PROGRESS:
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::requestResult --- 3 (%d)", mStatus);
            // collect results
            results.push_back(sResultMapping[mStatus]);
            mIsResultReady = TRUE;
            retCode = DIA_SUCCESS;
         }
         break;

      default:
         DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::requestResult --- 4");
         DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::requestResult mStatus = %d.",mStatus);
//         DIA_EN_RTCTRL_STATUS_UNKNOWN = 0,
//         DIA_EN_RTCTRL_STATUS_IDLE,
//         DIA_EN_RTCTRL_STATUS_IN_PROGRESS,
//         DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK,
//         DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK,
//         DIA_EN_RTCTRL_STATUS_ABORTED,
//         DIA_EN_RTCTRL_STATUS_TIMED_OUT,
//         DIA_EN_RTCTRL_STATUS_COUNT
         break;

      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tVoid
dia_RtCtrlSystemOperationTime_Reset::vOnServiceTimeout ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlSystemOperationTime_Reset::vOnServiceTimeout()");
   (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);
}

//------------------------------------------------------------------------------

tVoid
dia_RtCtrlSystemOperationTime_Reset::vOnSystemOperationTime_Reset ( tDiaResult success )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlSystemOperationTime_Reset::vOnSystemOperationTime_Reset()");

   if ( success == DIA_SUCCESS )
   {
      // set Status (eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);)
      // currently we only have a dummy implementation
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);

      // Push result into Result Vector

      // Sending back the positive answer
      DIA_TR_INF("=====================================================");
      DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::vOnSystemOperationTime_Reset Answer-Buffer:");
//      mResults.push_back(0x00);
      DIA_TR_INF("=====================================================");
      DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::vOnSystemOperationTime_Reset SUCCESSFUL.");
   } else {
//      mResults.push_back(0x01);
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
      DIA_TR_INF("dia_RtCtrlSystemOperationTime_Reset::vOnSystemOperationTime_Reset FAILED.");
   }

   // Variable for Service Handler Framework that this job is done //! indicate that we are done
   mIsResultReady = TRUE;
   // Interface abmelden
   (tVoid) unsetSysAdapterListener<dia_ISpmTimerIntervallListener>(this);

   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}
