/*!
 * \file       dia_RtCtrlReadWakeupHistoryForSwVer.cpp
 *
 * \brief      Class for UDS service LCM_ReadWakeupHistoryForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/production/dia_RtCtrlReadWakeupHistoryForSwVer.h"

namespace dia {

// convert received uds-request
bool dia_ReadWakeupHistoryForSWVersion::parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqWakeupHistoryForSWVersion &dia) {
   dia.mIndex=uds[0];
   return true;
}




// assemble answer
tDiaResult dia_ReadWakeupHistoryForSWVersion::assembleResult(dia_tSpmSVPWakeupHistoryForSWVersion  const &dia, std::vector<tU8>& uds) {
   dia_diaListToUds(dia.mList, uds, 10);
   dia_diaToUds(dia.mVersion, uds);
   return DIA_SUCCESS;
}


}
