/*!
 * \file       dia_RtCtrlReadSystemOperationTimeForSwVer.h
 *
 * \brief      Class for UDS service LCM_ReadSystemOperationTimeForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_RT_CTRL_READ_SYSTEM_OPERATION_TIME_FOR_SW_VER__
#define __INCLUDED_DIA_RT_CTRL_READ_SYSTEM_OPERATION_TIME_FOR_SW_VER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

#include "common/services/uds/production/dia_UdsHelpersSpm.h"
#include "common/framework/protocols/uds/rtctrl/dia_RoutineSimple.h"
#include "common/interfaces/dia_ISpmSVPListener.h"


#include "common/framework/protocols/uds/rtctrl/dia_RoutineSimple.h"

namespace dia {

class dia_ReadSystemOperationTimeForSWVersion : public dia_RoutineSimple<dia_ISpmSVP,
                                                                         dia_ISpmSVPListenerImpl,
                                                                         dia_tSpmSVPReqSystemOperationTimeForSWVersion,
                                                                         dia_tSpmSVPSystemOperationTimeForSWVersion>
{
   public:
   dia_ReadSystemOperationTimeForSWVersion ():
      dia_RoutineSimple("dia_ReadSystemOperationTimeForSWVersion", 
                        DIA_C_U16_DID_RBCM_READ_SYSTEM_OPERATION_TIME_FOR_SW_VERSION, 
                        DIA_EN_RTCTRL_ID_READ_SYSTEM_OPERATION_TIME_FOR_SW_VERSION){};

   bool parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqSystemOperationTimeForSWVersion &dia);
   tDiaResult assembleResult(dia_tSpmSVPSystemOperationTimeForSWVersion  const &dia, std::vector<tU8>& uds);
};


}
#endif

