/*!
 * \file       dia_RtCtrlReadStartupTimeStatisticForSwVer.h
 *
 * \brief      Class for UDS service LCM_ReadStartupTimeStatisticForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_RT_CTRL_READ_STARTUP_TIME_STATISTIC_FOR_SW_VER__
#define __INCLUDED_DIA_RT_CTRL_READ_STARTUP_TIME_STATISTIC_FOR_SW_VER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif
#ifndef __INCLUDED_DIA_INTERFACES__
#include "common/interfaces/dia_interfaces.h"
#endif

#include "common/interfaces/dia_ISpmSVPListener.h"


#include "common/services/uds/production/dia_UdsHelpersSpm.h"
#include "common/framework/protocols/uds/rtctrl/dia_RoutineSimple.h"
#include "common/interfaces/dia_ISpmSVPListener.h"

namespace dia {

class dia_ReadStartupTimeStatisticForSWVersion : public dia_RoutineSimple<dia_ISpmSVP,
                                                                          dia_ISpmSVPListenerImpl,
                                                                          dia_tSpmSVPReqStartupTimeStatisticForSWVersion,
                                                                          dia_tSpmSVPStartupTimeStatisticForSWVersion>
{
   public:
   dia_ReadStartupTimeStatisticForSWVersion ():
      dia_RoutineSimple("dia_ReadStartupTimeStatisticForSWVersion", 
                        DIA_C_U16_DID_RBCM_READ_STARTUP_TIME_STATISTIC_FOR_SW_VERSION, 
                        DIA_EN_RTCTRL_ID_READ_STARTUP_TIME_STATISTIC_FOR_SW_VERSION){};

   bool parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqStartupTimeStatisticForSWVersion &dia);
   tDiaResult assembleResult(dia_tSpmSVPStartupTimeStatisticForSWVersion  const &dia, std::vector<tU8>& uds);

};


}
#endif

