/*!
 * \file       dia_RtCtrlReadMaximumRamConsumptionForSwVer.cpp
 *
 * \brief      Class for UDS service LCM_ReadMaximumRamConsumptionForSWVersion
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesCommon
 *
 * \copyright  (c) 2018 Robert Bosch Car Multimedia
 *
 */

#include "common/services/uds/production/dia_RtCtrlReadMaximumRamConsumptionForSwVer.h"

namespace dia {

// convert received uds-request
bool dia_ReadMaximumRamConsumptionForSWVersion::parseRequest( std::vector<tU8> const &uds, dia_tSpmSVPReqMaximumRamConsumptionForSWVersion &dia) {
   // todo:check length of uds-input
   dia.mIndex=uds[0];
   return true;
}


// assemble answer
tDiaResult dia_ReadMaximumRamConsumptionForSWVersion::assembleResult(dia_tSpmSVPMaximumRamConsumptionForSWVersion  const &dia, std::vector<tU8>& uds) {
   dia_diaToUds(dia.mData, uds);
   dia_diaToUds(dia.mVersion, uds);
   return DIA_SUCCESS;
}

}
