/*
 * dia_RtCtrlGyroSelftest.h
 *
 *  Created on: 12.04.2012
 *      Author: hyo1szh
 */

#ifndef DIA_RTCTRLGYROSELFTEST_H_
#define DIA_RTCTRLGYROSELFTEST_H_

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__
#include "common/interfaces/dia_ISensorListener.h"
#endif

namespace dia
{

class RtCtrlGyroSelftest
   : public dia_Routine,
     public dia_ISensorListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RtCtrlGyroSelftest);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RtCtrlGyroSelftest);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! handle timeout from UDS session object
   virtual tVoid vOnServiceTimeout ( tVoid );

   //! result of the gyro selftest
   virtual tVoid vOnGyroSelfTestDone ( tDiaResult result );
};

} //namespace dia
#endif /* DIA_RTCTRLGYROSELFTEST_H_ */
