/*
 * dia_RtCtrlGyroSelftest.cpp
 *
 *  Created on: 12.04.2012
 *      Author: hyo1szh
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif

#include "dia_RtCtrlGyroSelftest.h"

namespace dia
{

//------------------------------------------------------------------------------

RtCtrlGyroSelftest::RtCtrlGyroSelftest ( tVoid )
   : dia_Routine("dia_RtCtrlGyroSelftest", 0x3043, DIA_EN_RTCTRL_ID_GYRO_SELFTEST,DIA_EN_RTCTRL_TYPE_SHORT_TERM)
{
   dia_tclFnctTrace oTrace("dia_RtCtrlGyroSelftest::dia_RtCtrlGyroSelftest()");
}

//------------------------------------------------------------------------------

RtCtrlGyroSelftest::~RtCtrlGyroSelftest ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_RtCtrlGyroSelftest::~dia_RtCtrlGyroSelftest !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
RtCtrlGyroSelftest::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlGyroSelftest::start()");
   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   dia_ISensor* pInterface = OSAL_NULL;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISensor>(&pInterface);
   if (diaResult == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_ISensorListener>(this);
         if (pInterface->vGyroSelfTest() == DIA_SUCCESS) {
            DIA_TR_INF("dia_RtCtrlGyroSelftest::vProcessRequest vGyroSelfTest SUCCESS.");
            eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
            retCode = DIA_SUCCESS;
         } else {
            DIA_TR_INF("dia_RtCtrlGyroSelftest::vProcessRequest vGyroSelfTest FAILED.");
         }
      }
   } else {
      DIA_TR_ERR("dia_RtCtrlGyroSelftest::start querySysAdapterInterface dia_ISensor FAILED!!!!");
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
RtCtrlGyroSelftest::requestResult ( std::vector<tU8>& results )
{
   ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tVoid
RtCtrlGyroSelftest::vOnServiceTimeout ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlGyroSelftest::vOnServiceTimeout()");
   (tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);
}

//------------------------------------------------------------------------------

tVoid
RtCtrlGyroSelftest::vOnGyroSelfTestDone ( tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlGyroSelftest::vOnGyroSelfTestDone()");

   if ( result == DIA_SUCCESS )
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   mIsResultReady = TRUE;
   (tVoid) unsetSysAdapterListener<dia_ISensorListener>(this);

   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

} //namespace dia
