/**
 * \file      dia_RtCtrlGetWifiSNR.cpp
 *
 * \brief     Routine Control for SNR of Wifi signal for specified Access Point
 *
 * \details   {insert file description here}
 *
 * \author    TMS Plischke, kaa1hi
 * \date      Aug 4, 2014
 *
 * \copyright Robert Bosch Car Multimedia 2014
 */

#ifndef dia_RtCtrlGetWifiSNR_H
#define dia_RtCtrlGetWifiSNR_H

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_LISTENER__
#include <common/interfaces/dia_IWifiListener.h>
#endif

namespace dia
{

class RtCtrlGetWifiSNR : public dia_Routine,
                             public dia_IWifiListenerImpl

{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RtCtrlGetWifiSNR);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RtCtrlGetWifiSNR);

   public:
      //! start the specified routine
      virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
      //! return control back to the ECU for the specified signal
      virtual tDiaResult requestResult ( std::vector<tU8>& results );
      //! handle timeout from UDS session object
      virtual void vOnServiceTimeout ( void );

      virtual void vOnWifiSNR ( const tU8 u8SNR  );

      virtual void vOnError ( const dia_ErrorInfoInterface& errInfo );
};

} //namespace dia
#endif
