/*
 * dia_RtCtrlCDDriveSelftest.h
 *
 *  Created on: 25.09.2012
 *      Author: shw2abt
 */

#ifndef DIA_RTCTRLCDDRIVESELFTEST_H_
#define DIA_RTCTRLCDDRIVESELFTEST_H_

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VD_MMGR_LISTENER__
#include "common/interfaces/dia_IVDMMGRListener.h"
#endif

namespace dia
{

class RtCtrlCDDriveSelftest
   : public dia_Routine,
     public dia_IVDMMGRListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RtCtrlCDDriveSelftest);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RtCtrlCDDriveSelftest);

private:
   tBool dia_MethodResultFirst;

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! handle timeout from UDS session object
   virtual tVoid vOnServiceTimeout ( tVoid );

   //! result on cd drive selfest start operation
   virtual tVoid vOnCDDriveSelftestStarted ( tDiaResult result );

   //! result of the cd drive selftest
   virtual tVoid vOnCDDriveSelftest ( tU8 duration, dia_tDriveTestResult& testResult );

private:
   const std::map<tU8, dia_eDriveTestType > mMapByteToTestType =
   {
      {0, DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT},
      {1, DIA_EN_MMGR_DRIVE_TEST_TYPE_INTENSIVE},
      {2, DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT_TEF}
   };
};

} //namespace dia

#endif /* DIA_RTCTRLCDDRIVESELFTEST_H_ */
