/*
 * dia_RtCtrlCDDriveSelftest.cpp
 *
 *  Created on: 25.09.2012
 *      Author: shw2abt
 */
// Original source code from dia_RtCtrlCDDriveSelftest.cpp
// DIA_REQ UDS 05 31 01 30 50 00 -> Short test
// DIA_REQ UDS 05 31 01 30 50 01 -> Long test
// DIA_REQ UDS 05 31 01 30 50 02 -> Short (TEF) test; for special MixMode CDs used for production

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_UDS_RTCTRL__
#include "common/framework/protocols/uds/rtctrl/dia_common_uds_rtctrl.h"
#endif


#define DIA_C_U8_ROUTINE_CTRL_CD_DRIVE_SELFTEST_PAYLOAD_SIZE    ((tU8) 1)
#define DIA_C_U8_ROUTINE_CTRL_CD_DRIVE_SELFTEST_RESPONSE_SIZE   ((tU8) 19)

#include "dia_RtCtrlCDDriveSelftest.h"

namespace dia
{

//------------------------------------------------------------------------------

RtCtrlCDDriveSelftest::RtCtrlCDDriveSelftest ( tVoid )
   : dia_Routine("dia_RtCtrlCDDriveSelftest", DIA_C_U16_DID_RBCM_MMGR_CDDRIVE_SELFTEST, DIA_EN_RTCTRL_ID_START_CD_DRIVE_SELFTEST, DIA_EN_RTCTRL_TYPE_LONG_TERM)
{
   dia_tclFnctTrace oTrace("dia_RtCtrlCDDriveSelftest::dia_RtCtrlCDDriveSelftest()");
   dia_MethodResultFirst = FALSE;
}

//------------------------------------------------------------------------------

RtCtrlCDDriveSelftest::~RtCtrlCDDriveSelftest ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IVDMMGRListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_RtCtrlCDDriveSelftest::~dia_RtCtrlCDDriveSelftest !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
RtCtrlCDDriveSelftest::start ( std::vector<tU8>& params, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlCDDriveSelftest::start()");
   tDiaResult retCode = DIA_FAILED;

   // prepare processing of the routine
   vInitialize();

   if (params.size() != DIA_C_U8_ROUTINE_CTRL_CD_DRIVE_SELFTEST_PAYLOAD_SIZE)
   {
      DIA_TR_ERR("dia_RtCtrlCDDriveSelftest::start INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT size=%zu, exp size=%u.", params.size(), DIA_C_U8_ROUTINE_CTRL_CD_DRIVE_SELFTEST_PAYLOAD_SIZE);
      return DIA_E_INVALID_MESSAGE_LENGHT_OR_INVALID_FORMAT;
   }

   dia_IVDMMGR* pInterface = 0;
   if ((querySysAdapterInterface<dia_IVDMMGR>(&pInterface) == DIA_SUCCESS) && pInterface)
   {
      (void) setSysAdapterListener<dia_IVDMMGRListener>(this);
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::start Got interface.");
   }
   else
   {
      DIA_TR_ERR("dia_RtCtrlCDDriveSelftest::start Interface not found.");
      return DIA_E_CONDITIONS_NOT_CORRECT;
   }

   dia_eDriveTestType testType = DIA_EN_MMGR_DRIVE_TEST_TYPE_UNKNOWN;

   std::map<tU8, dia_eDriveTestType >::const_iterator it = mMapByteToTestType.find(params.at(0));
   if ( it != mMapByteToTestType.end() )
   {
      testType = it->second;
      if      (DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT==testType)     DIA_TR_INF("dia_RtCtrlCDDriveSelftest::start DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT");
      else if (DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT_TEF==testType) DIA_TR_INF("dia_RtCtrlCDDriveSelftest::start DIA_EN_MMGR_DRIVE_TEST_TYPE_SHORT_TEF");
      else if (DIA_EN_MMGR_DRIVE_TEST_TYPE_INTENSIVE==testType) DIA_TR_INF("dia_RtCtrlCDDriveSelftest::start DIA_EN_MMGR_DRIVE_TEST_TYPE_INTENSIVE");
   }

   if (DIA_EN_MMGR_DRIVE_TEST_TYPE_UNKNOWN!=testType)
   {
      (void) setSysAdapterListener<dia_IVDMMGRListener>(this);
      if (pInterface->startCDDriveTest(testType) == DIA_SUCCESS)
      {
         DIA_TR_INF("dia_RtCtrlCDDriveSelftest::start startCDDriveTest SUCCESS.");
         eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
         dia_MethodResultFirst = TRUE;
         retCode = DIA_SUCCESS;
      }
   }
   else
   {
      DIA_TR_ERR("dia_RtCtrlCDDriveSelftest::start - Wrong test type 0x%02X.", testType);
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
RtCtrlCDDriveSelftest::requestResult ( std::vector<tU8>& results )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlCDDriveSelftest::requestResult()");
   tDiaResult retCode = DIA_E_SEQUENCE_ERROR;

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 2");

      switch ( mStatus )
      {
         case DIA_EN_RTCTRL_STATUS_IN_PROGRESS:
         {
            DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 3 STATUS_IN_PROGRESS");

            // collect results
            if (dia_MethodResultFirst==TRUE)
            {
               DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 3 ResultFirst - short answer ");
               // 1. answer message for process started
               results.push_back(mapStatus2UDSResult());
               dia_MethodResultFirst = FALSE;
            }
            else
            {
               // collect results
               DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 3 ResultFirst - long answer ");
               // 2. answer message for running process
               results.push_back(mapStatus2UDSResult());
               for (int i = 0; i<(DIA_C_U8_ROUTINE_CTRL_CD_DRIVE_SELFTEST_RESPONSE_SIZE-1); i++)
               {
                  results.push_back(0x00);
               }
            }

            mIsResultReady = TRUE;
            retCode = DIA_SUCCESS;
         }
         break;

         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
         case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 3 (mStatus=%d)", mStatus);
            // collect results
            results.push_back(mapStatus2UDSResult());

            DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 3 mResults.size() = %zu.", mResults.size());

            if (mResults.size()==0)
            {
               DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 3 mResults.size()==0 => EMPTY.");
               for (int i=0; i<(DIA_C_U8_ROUTINE_CTRL_CD_DRIVE_SELFTEST_RESPONSE_SIZE-1); i++)
               {
                  results.push_back(0x00);
               }
               mResults.clear();
            }

            mIsResultReady = TRUE;
            retCode = DIA_SUCCESS;
         }
         break;

         case DIA_EN_RTCTRL_STATUS_ABORTED:
         {
            DIA_TR_ERR("dia_RtCtrlCDDriveSelftest::requestResult DIA_EN_RTCTRL_STATUS_ABORTED");
            mIsResultReady = TRUE;
            retCode = DIA_FAILED;
         }
         break;

         default:
         {
            DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult --- 4");
            DIA_TR_INF("dia_RtCtrlCDDriveSelftest::requestResult mStatus = %d.",mStatus);
         }
         break;
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tVoid
RtCtrlCDDriveSelftest::vOnServiceTimeout ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlCDDriveSelftest::vOnServiceTimeout()");
   (tVoid) unsetSysAdapterListener<dia_IVDMMGRListener>(this);
}

//------------------------------------------------------------------------------

tVoid
RtCtrlCDDriveSelftest::vOnCDDriveSelftestStarted ( tDiaResult result )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftestStarted()");

   DIA_TR_INF("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftestStarted result=0x%08X", result);

   if ( result == DIA_SUCCESS )
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftestStarted eSetStatus = DIA_EN_RTCTRL_STATUS_IN_PROGRESS");
   }
   else
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_ABORTED);
      DIA_TR_ERR("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftestStarted eSetStatus = DIA_EN_RTCTRL_STATUS_ABORTED");
   }

   mIsResultReady = TRUE;
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

//------------------------------------------------------------------------------

tVoid
RtCtrlCDDriveSelftest::vOnCDDriveSelftest ( tU8 duration, dia_tDriveTestResult& testResult )
{
   dia_tclFnctTrace oTrace("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftest()");

   if ( duration < 0xFF ) // TODO - Sinnvolle Testabfrage
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);

      // Push result into Result Vector
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftest Return Data:");
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftest duration %d",duration);
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftest methodResultDriveTest:");
      DIA_TR_INF("methodResultDriveTest.e8RetValueDriveTest.enType 0x%08x", testResult.mReturnValue);
      DIA_TR_INF("methodResultDriveTest.e16DiagDrvTesttype.enType  %d", testResult.mTestType);
      DIA_TR_INF("methodResultDriveTest.e16Drive.enType            %d", testResult.mType);
      DIA_TR_INF("methodResultDriveTest.u32SectorsRead             %d", testResult.mSectorsRead);
      DIA_TR_INF("methodResultDriveTest.u16ReadAttemps             %d", testResult.mReadAttemps);
      DIA_TR_INF("methodResultDriveTest.u16CntErrors               %d", testResult.mErrorCount);
      DIA_TR_INF("methodResultDriveTest.u16AverageReadtimeSector   %d", testResult.mAverageReadTimePerSector);
      DIA_TR_INF("methodResultDriveTest.u32TotalReadTime           %d", testResult.mTotalReadTime);
      DIA_TR_INF("methodResultDriveTest.u16MaxReadTimePerSector    %d", testResult.mMaxReadTimePerSector);
      DIA_TR_INF("methodResultDriveTest.u32MaxLBA                  %d", testResult.mMaxLBA);
      DIA_TR_INF("methodResultDriveTest.u8CntDVDLayer              %d", testResult.mCntDVDLayer);

      // Sending back the positive answer
      DIA_TR_INF("=========================================================");
      DIA_TR_INF("dia_RtCtrlCDDriveSelftest::vOnCDDriveSelftest Answer-Buffer:");
//    Byte   Var                     Length
//    0      status                  1B:
      DIA_TR_INF("eSetStatus -  DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK.");
      mResults.push_back(mapStatus2UDSResult());
//    1      Sectors read            4B
      DIA_TR_INF("methodResultDriveTest.u32SectorsRead             %d", testResult.mSectorsRead);
      mResults.push_back(U32_BYTE1(testResult.mSectorsRead));
      mResults.push_back(U32_BYTE2(testResult.mSectorsRead));
      mResults.push_back(U32_BYTE3(testResult.mSectorsRead));
      mResults.push_back(U32_BYTE4(testResult.mSectorsRead));
//    5      Read atemps             2B
      DIA_TR_INF("methodResultDriveTest.u16ReadAttemps             %d", testResult.mReadAttemps);
      mResults.push_back(U16_BYTE1(testResult.mReadAttemps));
      mResults.push_back(U16_BYTE2(testResult.mReadAttemps));
//    7      Read errors             2B
      DIA_TR_INF("methodResultDriveTest.u16CntErrors               %d", testResult.mErrorCount);
      mResults.push_back(U16_BYTE1(testResult.mErrorCount));
      mResults.push_back(U16_BYTE2(testResult.mErrorCount));
//    9      Total Read Time         4B
      DIA_TR_INF("methodResultDriveTest.u32TotalReadTime           %d", testResult.mTotalReadTime);
      mResults.push_back(U32_BYTE1(testResult.mTotalReadTime));
      mResults.push_back(U32_BYTE2(testResult.mTotalReadTime));
      mResults.push_back(U32_BYTE3(testResult.mTotalReadTime));
      mResults.push_back(U32_BYTE4(testResult.mTotalReadTime));
//    13      Max sectors read time  2B
      DIA_TR_INF("methodResultDriveTest.u16MaxReadTimePerSector    %d", testResult.mMaxReadTimePerSector);
      mResults.push_back(U16_BYTE1(testResult.mMaxReadTimePerSector));
      mResults.push_back(U16_BYTE2(testResult.mMaxReadTimePerSector));
//    15      Max LBA                4B
      DIA_TR_INF("methodResultDriveTest.u32MaxLBA                  %d", testResult.mMaxLBA);
      mResults.push_back(U32_BYTE1(testResult.mMaxLBA));
      mResults.push_back(U32_BYTE2(testResult.mMaxLBA));
      mResults.push_back(U32_BYTE3(testResult.mMaxLBA));
      mResults.push_back(U32_BYTE4(testResult.mMaxLBA));
      DIA_TR_INF("=========================================================");
      DIA_TR_INF("=> WRITE ALL DATA TO mResults - WAIT FOR RESULT-REQUEST =");
      DIA_TR_INF("=========================================================");
   }
   else
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   // Variable for Service Handler Framework that this job is done
   mIsResultReady = TRUE;
}

} //namespace dia