/*
 * dia_RtCtrlAccSelftest.h
 *
 *  Created on: 12.04.2012
 *      Author: hyo1szh
 */

#ifndef DIA_RTCTRLACCSELFTEST_H_
#define DIA_RTCTRLACCSELFTEST_H_

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SENSOR_LISTENER__
#include "common/interfaces/dia_ISensorListener.h"
#endif

namespace dia
{

class RtCtrlAccSelftest
   : public dia_Routine,
     public dia_ISensorListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RtCtrlAccSelftest);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RtCtrlAccSelftest);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! handle timeout from UDS session object
   virtual tVoid vOnServiceTimeout ( tVoid );

   //! result of the acc selftest
   virtual tVoid vOnAccSelfTestDone ( tDiaResult result );
};

} //namespace dia

#endif /* DIA_RTCTRLACCSELFTEST_H_ */
