/*
 * dia_RoutineCtrlVerifySecuritySettingsSCC.h
 *
 *  Created on: 19.02.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ROUTINE_VERIFY_SECURITY_SETTINGS_SCC__
#define __INCLUDED_DIA_ROUTINE_VERIFY_SECURITY_SETTINGS_SCC__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

//#ifndef __INCLUDED_DIA_ROUTINE_CTRL_EXECUTE_SYSTEM_COMMAND__
//#include <common/services/uds/generic/dia_RoutineCtrlExecuteSystemCommand.h>
//#endif

#ifndef __INCLUDED_DIA_ROUTINE_CTRL_GENERIC_SECURITY_SETTINGS_SCC__
#include <common/services/uds/generic/dia_RoutineCtrlGenericSecuritySettingsSCC.h>
#endif

namespace dia
{

class RoutineCtrlVerifySecuritySettingsSCC
   : public RoutineCtrlGenericSecuritySettingsSCC
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlVerifySecuritySettingsSCC);
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlVerifySecuritySettingsSCC);

public:
   virtual tU32 getMaxProcessingTime ( void ) const { return 15000; }

   const std::vector<tU8>& getJtagCRC ( void ) const { return mJtagCRC; }

protected:
   //! evaluate the parameters passed to this start routine method
   virtual tDiaResult evaluateStartParameters ( std::vector<tU8>& /*params*/ );
   //! populate the argument vector with command line arguments
   virtual tDiaResult getCommandArguments ( std::vector<std::string>& /*argv*/);
   //! evaluate the exit code
   virtual tDiaResult evaluateCommandResponse ( int exitCode );
   //! read security byte from file
   virtual tDiaResult readSecurityByte ( tU8& securityByte );

protected:
   static const tU16 mSizeOfJtagCRC;
   static const tU16 mSizeOfParams;
   std::vector<tU8> mJtagCRC;
   std::string mTmpFileName;
   tU8 mSecurityByte;
};

}

#endif /* __INCLUDED_DIA_ROUTINE_VERIFY_SECURITY_SETTINGS_SCC__ */
