/*!
 * \file       dia_RoutineCtrlTouchSelfTest.h
 *
 * \brief      Start Touch_controller_Selftest_Atmel_T25 and retrieve respective result.
 *
 * \details    The diagnosis tester shall be able to start the Touch_controller_Selftest_Atmel_T25 and retrieve the respective result. Type 1 Routine Control service.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaInputHandling
 *
 * \copyright  (c) 2015-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef DIA_ROUTINECTRLTOUCHSELFTEST_H_
#define DIA_ROUTINECTRLTOUCHSELFTEST_H_

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

namespace dia
{

class RoutineCtrlTouchSelfTest
   : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlTouchSelfTest);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlTouchSelfTest);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class

   //! return DIA_SUCCESS or DIA_E_SEQUENCE_ERROR in case of failure
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! Function retrieves the data based on Property ID.
   tDiaResult getPropertyDetails( tU32 PropID);

private:
   static const tU8 PATH_SIZE = 128; // maximum allowed path size
   tChar m_TouchDevicePath[PATH_SIZE];
};

} //namespace dia

#endif /* DIA_ROUTINECTRLTOUCHSELFTEST_H_ */
