/*
 * dia_RoutineCtrlTouchPanelAlignment.h
 *
 *  Created on: 07.03.2014
 *      Author: wgl2hi
 */

#ifndef __INCLUDED_DIA_ROUTINECTRL_TOUCHPANELALIGNMENT__
#define __INCLUDED_DIA_ROUTINECTRL_TOUCHPANELALIGNMENT__

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#include "common/interfaces/dia_IInputHandlingListener.h"

namespace dia
{

class RoutineCtrlTouchPanelAlignment
   : public dia_Routine,
     public dia_IInputHandlingListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlTouchPanelAlignment);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlTouchPanelAlignment);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class

   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( tVoid ) const { return 60000; }

   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( tVoid );

   //! touch panel alignment procedure is finished
   virtual void vOnTouchPanelAlignmentDone ( tDiaResult result );
};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINECTRL_TOUCHPANELALIGNMENT__ */
