/************************************************************************
* FILE:         dia_RoutineCtrStressTest.h
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service StressTest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 10.11.14  | TMS Plischke            | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_ROUTINE_STRESSTEST__
#define __INCLUDED_DIA_ROUTINE_STRESSTEST__


namespace dia
{

class RoutineCtrlStressTest : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlStressTest);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlStressTest);

   public:
   RoutineCtrlStressTest (tCString name, tU16 udsID, dia_eRoutineID routineID);

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult stop ( std::vector<tU8>& params); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   virtual tU32 getMaxProcessingTime ( void ) const { return 5000; }

   private:
   tU8 statusResponse;
   pid_t child_pid;
   bool isRunning;

   bool parseargv(char *param, char **argv) const;
   tVoid parsecmd(char *param, char **cmd) const;
   tVoid killChilds(pid_t pid) const;
};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINE_STRESSTEST__ */

