/*
 * dia_RoutineCtrlStartSoftwareUpdate.cpp
 *
 *  Created on: 22.08.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

// include own class
#include "dia_RoutineCtrlStartSoftwareUpdate.h"

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif

namespace dia
{

//------------------------------------------------------------------------------

RoutineCtrlStartSoftwareUpdate::RoutineCtrlStartSoftwareUpdate ( void )
   : dia_Routine("dia_RoutineCtrlStartSoftwareUpdate",(tU16) DIA_C_U16_DID_RBCM_RTCTRL_LCM_START_SOFTWARE_UPDATE, DIA_EN_RTCTRL_TYPE_SHORT_TERM )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlStartSoftwareUpdate::dia_RoutineCtrlStartSoftwareUpdate()");
}

//------------------------------------------------------------------------------

RoutineCtrlStartSoftwareUpdate::~RoutineCtrlStartSoftwareUpdate ( void )
{}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlStartSoftwareUpdate::start ( std::vector<tU8>& /*params*/, tU8 /*timerValue*/ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlStartSoftwareUpdate::start()");

   // prepare processing of the routine
   vInitialize();

   tBool errorDetected = TRUE;

   dia_ISwUpdate* pInterface = OSAL_NULL;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISwUpdate>(&pInterface);

   if (diaResult == DIA_SUCCESS)
   {
      if (pInterface)
      {
         (void) setSysAdapterListener<dia_ISwUpdateListener>(this);

         if (pInterface->enterRecoveryMode() == DIA_SUCCESS)
         {
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_ERR("dia_RoutineCtrlStartSoftwareUpdate::start --- SEND TO SW UPDATE SERVER FAILED !!!");
         }
      }
      else
      {
         DIA_TR_ERR("dia_RoutineCtrlStartSoftwareUpdate::start --- pInterface is NULL.");
      }
   }

   if ( errorDetected )
   {
     DIA_TR_ERR("dia_RoutineCtrlStartSoftwareUpdate::start -- errorDetected TRUE !!!");
   }
   else
   {
     eSetStatus(DIA_EN_RTCTRL_STATUS_IN_PROGRESS);
   }

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
RoutineCtrlStartSoftwareUpdate::requestResult ( std::vector<tU8>& results )
{
   dia::ScopeTrace oTrace(__PRETTY_FUNCTION__);

   results.push_back(mapStatus2UDSResult());

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

void
RoutineCtrlStartSoftwareUpdate::vOnRecoveryMode ( tBool recoveryMode )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlStartSoftwareUpdate::vOnRecoveryMode()");

   if ( TRUE==recoveryMode )
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
   }
   else
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }

   mIsResultReady = TRUE;
   (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);

   // call requestResult (send positive answer) and then wait for reset
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}

//------------------------------------------------------------------------------

void
RoutineCtrlStartSoftwareUpdate::vOnServiceTimeout ( void )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlStartSoftwareUpdate::vOnServiceTimeout()");
   (void) unsetSysAdapterListener<dia_ISwUpdateListener>(this);
}

} //namespace dia
