/**
 * \file      dia_RoutineCtrlSetDiagnositicsToDeliveryState.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gco1szh
 * \date      20.03.2017
 *
 * \copyright Robert Bosch Car Multimedia 2017
 */


#ifndef __INCLUDED_DIA_ROUTINE_CTRL_SET_DIAGNOSTICS_TO_DELIVERY_STATE__
#define __INCLUDED_DIA_ROUTINE_CTRL_SET_DIAGNOSTICS_TO_DELIVERY_STATE__

#ifndef __INCLUDED_DIA_COMMON_SYSSET__
#include "common/framework/sysset/dia_common_sysset.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS_LISTENER__
#include <common/interfaces/dia_ISystemSettingsListener.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif


namespace dia
{

class RoutineCtrlSetDiagnosticsToDeliveryState
   : public dia_Routine,
     public dia_ISystemSettingsListener
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(RoutineCtrlSetDiagnosticsToDeliveryState);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(RoutineCtrlSetDiagnosticsToDeliveryState);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return 60000; }

   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );

   virtual void onSystemSettingProcessed ( dia_UID typeID, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, tCookieType cookie );

};

} //namespace dia

#endif /* __INCLUDED_DIA_ROUTINE_CTRL_SET_DIAGNOSTICS_TO_DELIVERY_STATE__ */
