/**
 * \file      dia_RoutineCtrlPhoneConnectBluetoothDevice.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      19.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_PHONE_CONNECT_BLUETOOTH_DEVICE__
#define __INCLUDED_DIA_ROUTINE_CONTROL_PHONE_CONNECT_BLUETOOTH_DEVICE__

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"
#endif

#ifndef __INCLUDED_DIA_BLUETOOTHCONNECTIONFSM__
#include "common/framework/fsm/generated/dia_BluetoothConnectionFSM.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include "common/interfaces/dia_IBluetoothListener.h"
#endif


class dia_RoutineCtrlPhoneConnectBluetoothDevice
   : public dia_Routine,
     public dia_IBluetoothListenerImpl,
     protected dia_BluetoothConnectionFSM::FsmBehaviour
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlPhoneConnectBluetoothDevice);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlPhoneConnectBluetoothDevice);

public:
   // initial initialization of the FSM
   virtual tVoid vInit ( tVoid );

   //
   // overloaded methods from dia_Routine
   //

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //
   // overloaded methods from dia_IBluetoothListenerImpl
   //

   //! connection status
   virtual tVoid vOnConnectionStatus ( tBool status );
   //! acknowledge status for the disconnect request
   virtual tVoid vOnDisconnectionStatus ( tBool status );

   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( tVoid ) const { return 15000; }

   //! handle timeout from UDS session object
   virtual tVoid vOnServiceTimeout ( tVoid );

protected:
   //-------------------------------------------------------------------------
   //
   // Overloaded dia_BluetoothModeFSM::FsmBehaviour methods
   //
   //-------------------------------------------------------------------------

   //---- FSM actions------

   //! create negative response
   virtual void vFsmSendPositiveResponse ( void* pArg );
   //! create negative response
   virtual void vFsmSendNegativeResponse ( void* pArg );
   //! handle connection to the BT devivce
   virtual void vFsmSetStateConnected ( void* pArg );
   //! handle disconnection to the BT devivce
   virtual void vFsmSetStateNotConnected ( void* pArg );
   //! request connection to a given BT device
   virtual void vFsmSendConnectRequest ( void* pArg );
   //! request disconnection to a given BT device
   virtual void vFsmSendDisconnectRequest ( void* pArg );
   //! evaluate the error scenario
   virtual void vFsmHandleError ( void* pArg );

   //---- FSM guards ----

   //! check if CCA message was successfully sent to CCA component
   virtual bool bFsmWasMsgSentOK ( void* pArg );
   //! check if connection to bluetooth phone module is established
   virtual bool bFsmIsConnected ( void* pArg );
   //! check if connection to bluetooth phone module is not established
   virtual bool bFsmIsDisconnected ( void* pArg );
   //! check if the requested bluetooth address is already connected
   virtual bool bFsmIsSameAddress ( void* pArg );

protected:
   //! address of the device to be connected to
   tChar mBTAddress[18];
   //! address of the device to be connected to
   tChar mBTAddressConnected[18];
   //! error code
   tDiaResult mErrorCode;
   //! interface pointer used to interact with the BT module
   dia_IBluetooth* mpBTInterface;
   //! pointer to the FSM
   dia_BluetoothConnectionFSM::Fsm* mpBTConnectFSM;

   //! connection status (true = connected, false = disconnected
   tBool mConnectionStatus;
   //! flag used to check if a CCA message was sent successfully
   tBool mSendStatus;
};

#endif /* __INCLUDED_DIA_ROUTINE_CONTROL_PHONE_CONNECT_BLUETOOTH_DEVICE__ */


