/*
 * dia_RoutineCtrlLcmStartAlternativeSoftware.cpp
 *
 *  Created on: 18.01.2014
 *      Author: nbs3kor
 */

#ifndef DIA_ROUTINECTRLLCMSTARTALTERNATIVESOFTWARE_H_
#include "dia_RoutineCtrlLcmStartAlternativeSoftware.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_ROUTINE_CONTROL_MANAGER__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineCtrlManager.h"
#endif


static tU8 sResultMapping[DIA_EN_RTCTRL_STATUS_COUNT] = {
     0xFF, //DIA_EN_RTCTRL_STATUS_UNKNOWN
     0xFF, //DIA_EN_RTCTRL_STATUS_IDLE
     0xFF, //DIA_EN_RTCTRL_STATUS_IN_PROGRESS
     0x00, //DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK
     0x01, //DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK
     0xFF, //DIA_EN_RTCTRL_STATUS_ABORTED
     0xFF  //DIA_EN_RTCTRL_STATUS_TIMED_OUT
};

//------------------------------------------------------------------------------

dia_RoutineCtrlLcmStartAlternativeSoftware::dia_RoutineCtrlLcmStartAlternativeSoftware ( void )
   : dia_RoutineLong("dia_RoutineCtrlLcmStartAlternativeSoftware",(tU16) DIA_C_U16_DID_RBCM_RTCTRL_LCM_START_ALTERNATIVE_SOFTWARE, DIA_EN_RTCTRL_ID_START_DOWNLOAD,DIA_EN_RTCTRL_MONITORING_MODE_NOT_SUPPORTED),
     mSystemRestartMode(DIA_EN_SPM_RESTART_MODE_UNKNOWN)
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlLcmStartAlternativeSoftware::dia_RoutineCtrlLcmStartAlternativeSoftware()");
}

//------------------------------------------------------------------------------

dia_RoutineCtrlLcmStartAlternativeSoftware::~dia_RoutineCtrlLcmStartAlternativeSoftware ( void )
{}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlLcmStartAlternativeSoftware::start ( std::vector<tU8>& params, tU8 /*timerValue */ )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlLcmStartAlternativeSoftware::start()");

   // prepare processing of the routine
   vInitialize();

   if ( (params.size() != 1) || ((params[0] != 0x00) && (params[0] != 0x01)) )
   {
      DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start params.size()=%zu INVALID PARAMETERS", params.size());
      return DIA_FAILED;
   }

   tBool errorDetected = TRUE;

   dia_ISpm* pInterface = OSAL_NULL;
   tDiaResult diaResult = querySysAdapterInterface<dia_ISpm>(&pInterface);

   if (diaResult == DIA_SUCCESS)
   {
      if (pInterface)
      {
         (void) setSysAdapterListener<dia_ISpmListener>(this);

         switch(params[0])
         {
            case 0x00:
               DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start SENDING RESTART MODE_ECU_ALTSW_TESTMANAGER.");
               mSystemRestartMode = DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_TESTMANAGER;
            break;

            case 0x01:
               DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start SENDING RESTART MODE_ECU_ALTSW_NAC_TESTSOFTWARE.");
               mSystemRestartMode = DIA_EN_SPM_RESTART_MODE_ECU_ALTSW_NAC_TESTSOFTWARE;
            break;

            default:
               DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start WRONG PARAMETER -- %d", mSystemRestartMode);
               mSystemRestartMode = DIA_EN_SPM_RESTART_MODE_UNKNOWN;
            break;
         }

         if (pInterface->lcmSystemRestart(mSystemRestartMode) == DIA_SUCCESS)
         {
            DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start lcmSystemRestart successful");
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start lcmSystemRestart failed");
            DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
         }
      }
      else
      {
         DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start pInterface NULL");
      }
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start querySysAdapterInterface failed");
   }

   if ( errorDetected )
   {
      DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
      DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::start errorDetected is true");
      return DIA_FAILED;
   }

   // mIsResultReady is not set to TRUE, because answer will be sent when service handler has got confirmation from SPM
   // mStatus is not set, because answer will be sent when service handler has got confirmation from SPM

   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_RoutineCtrlLcmStartAlternativeSoftware::requestResult ( std::vector<tU8>&  results )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlLcmStartAlternativeSoftware::requestResult()");

   tDiaResult retCode = DIA_E_SEQUENCE_ERROR;

   results.clear();
   if ( !(mResults.empty()) )
   {
      DIA_TR_INF("requestResult --- 1");
      std::vector<tU8>::iterator iter = mResults.begin();
      for ( ; iter != mResults.end(); iter++ )
      {
         results.push_back(*iter);
      }
      mResults.clear();
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("requestResult --- 2");
      switch ( mStatus )
      {
      case DIA_EN_RTCTRL_STATUS_IN_PROGRESS:
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK:
      case DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK:
         {
            DIA_TR_INF("requestResult --- 3 (%d)", mStatus);
            // collect results
            results.push_back(sResultMapping[mStatus]);
            retCode = DIA_SUCCESS;
         }
         break;

      default:
         DIA_TR_INF("requestResult --- 4 (%d)", mStatus);
         break;

      }
   }

   return retCode;
}

void
dia_RoutineCtrlLcmStartAlternativeSoftware::vOnGetSystemRestartValue ( dia_eSpmRestartMode mode )
{
   dia_tclFnctTrace oTrace("dia_RoutineCtrlLcmStartAlternativeSoftware::vOnGetSystemRestartValue()");
   if (mode == mSystemRestartMode)
   {
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_OK);
      DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::vOnGetSystemRestartValue COMPLETED OK.");
   }
   else
   {
      DIA_TR_INF("dia_RoutineCtrlLcmStartAlternativeSoftware::vOnGetSystemRestartValue mode=%d COMPLETED NOK!", mode);
      eSetStatus(DIA_EN_RTCTRL_STATUS_COMPLETED_AND_NOK);
   }
   mIsResultReady = TRUE;
   (void) unsetSysAdapterListener<dia_ISpmListener>(this);

   // call requestResult (send positive answer) and then wait for reset
   dia_RoutineCtrlManager::getInstance()->vOnRoutineUpdate(*this);
}
