/************************************************************************
* FILE:         dia_RoutineCtrlDisplayTestScreenSlideshow.h
* PROJECT:      GM NexGen
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Classes for UDS service StressTest
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                  | Modification
* 10.11.14  | TMS Plischke            | initial version
*
*************************************************************************/

#ifndef __INCLUDED_DIA_ROUTINE_DISPLAY_TESTSCREEN_SLIDESHOW__
#define __INCLUDED_DIA_ROUTINE_DISPLAY_TESTSCREEN_SLIDESHOW__

#if 0 // gib2hi: disabled as dia_IHMI/dia_IHMIListener are project specific interfaces
#ifndef __INCLUDED_DIA_INTERFACE_HMI_LISTENER__
#include <project/interfaces/dia_IHmiListener.h>
#endif
#endif

class dia_RoutineCtrlDisplayTestScreenSlideshow 
   : public dia_Routine
#if 0 // gib2hi: disabled as dia_IHMI/dia_IHMIListener are project specific interfaces
   , public dia_IHmiListenerImpl
#endif
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlDisplayTestScreenSlideshow);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlDisplayTestScreenSlideshow);

   public:

   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult stop ( std::vector<tU8>& params); //lint !e1735 Info: verified that same default parameter is used as in base class
   virtual tDiaResult requestResult ( std::vector<tU8>& /*results*/ );

#if 0 // gib2hi: disabled as dia_IHMI/dia_IHMIListener are project specific interfaces
   virtual tVoid vOnIoCtrlTestscreenResult(const tenIoControlAction enAction, const tU8 u8TestscreenId);
   virtual tVoid vOnIoCtrlTestscreenError ( const tU32 errCode );
#endif

   private:
      tU32  delay;
      std::vector<tU8> testscreenList;
      bool  isRunning;
      tU8   currentTestscreen;
      tU32  numberOfTestScreens;
      tU8   statusResponse;


   tDiaResult sendTestscreen ( tU8 testscreen ) const;
};


#endif /* __INCLUDED_DIA_ROUTINE_DISPLAY_TESTSCREEN_SLIDESHOW__ */

