/*!
 * \file       dia_RoutineCtrlConfigureSecuritySettingsSCC.cpp
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2016 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_ROUTINE_CONFIGURE_SECURITY_SETTINGS_SCC__
#include <common/services/uds/production/dia_RoutineCtrlConfigureSecuritySettingsSCC.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

#define DIA_C_U8_BITMASK_MSB_ON_CHIP_DEBUG_ENABLE  ((tU8) 0x80)

static const std::string fullCmdName("/opt/bosch/base/bin/swu_common_v850_app_out.out");

namespace dia
{

const tU16 RoutineCtrlConfigureSecuritySettingsSCC::mSizeOfJtagID = 12;
const tU16 RoutineCtrlConfigureSecuritySettingsSCC::mSizeOfParams = 13;

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlConfigureSecuritySettingsSCC::RoutineCtrlConfigureSecuritySettingsSCC ( void )
   : RoutineCtrlGenericSecuritySettingsSCC("RoutineCtrlConfigureSecuritySettingsSCC", DIA_C_U16_ID_RTCTRL_JTAG_ID_AND_SECURITY_BYTE_CONFIGURE, fullCmdName),
     mSecurityBits(0)

{
   dia_tclFnctTrace oTrace("dia::RoutineCtrlConfigureSecuritySettingsSCC::RoutineCtrlConfigureSecuritySettingsSCC");
   mJtagID.clear();
}

//---------------------------------------------------------------------------------------------------------------------

RoutineCtrlConfigureSecuritySettingsSCC::~RoutineCtrlConfigureSecuritySettingsSCC()
{}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
RoutineCtrlConfigureSecuritySettingsSCC::evaluateStartParameters ( std::vector<tU8>& params )
{
   if ( params.size() != mSizeOfParams )
   {
      DIA_TR_INF("RoutineCtrlConfigureSecuritySettingsSCC::evaluateStartParameters INVALID PARAMETERS (expected = %u, actually = %zu)", mSizeOfParams, params.size());
      return DIA_FAILED;
   }

   if ( (params[0] & DIA_C_U8_BITMASK_MSB_ON_CHIP_DEBUG_ENABLE) != DIA_C_U8_BITMASK_MSB_ON_CHIP_DEBUG_ENABLE )
   {
      DIA_TR_INF("RoutineCtrlConfigureSecuritySettingsSCC::evaluateStartParameters INVALID PARAMETERS (DETECTED ON CHIP DEBUG FLAG ENABLE)");
      return DIA_E_OUT_OF_RANGE;
   }

   // extract JTAG ID
   mJtagID.clear();
   mJtagID.insert(mJtagID.end(),params.begin(),params.begin()+mSizeOfJtagID);
   DIA_TR_INF("RoutineCtrlConfigureSecuritySettingsSCC::start JTAG-ID = '%s'", dia::utils::bin2str(mJtagID,' ').c_str());

   mSecurityBits = params[mSizeOfParams-1];
   DIA_TR_INF("RoutineCtrlConfigureSecuritySettingsSCC::start SecBits = 0x%02x", mSecurityBits);

   return DIA_SUCCESS;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
RoutineCtrlConfigureSecuritySettingsSCC::getCommandArguments ( std::vector<std::string>& argv )
{
   argv.push_back("-s");
   argv.push_back(dia::utils::byte2hexstr(mSecurityBits, true));
   argv.push_back("-j");
   argv.push_back(dia::utils::bin2hexstr(mJtagID, true));

   return DIA_SUCCESS;
}

}
