/*
 * dia_RoutineCtrlChecksum.h
 *
 *  Created on: 19.02.2014
 *      Author: kaa1hi
 */

#ifndef DIA_ROUTINECTRLCHECKSUM_H_
#define DIA_ROUTINECTRLCHECKSUM_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_ROUTINE__
#include "common/framework/protocols/uds/rtctrl/dia_Routine.h"    //needed by class dia_RoutineCtrlChecksum
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include "common/framework/application/dia_Lock.h"
#endif

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef DIA_INOUTTHREADPARAM_H_
#include "common/services/uds/production/dia_InOutThreadParam.h"
#endif


enum dia_eScriptErrorCode
{
   DIA_EN_ERROR_CODE_OK,                                                               /* 0 */
   DIA_EN_ERROR_CODE_CHECK_PERFORMED_CHECKSUM_DO_NOT_MATCH,                            /* 1 */
   DIA_EN_ERROR_CODE_CHECK_PERFORMED_CHECKSUM_DO_NOT_MATCH_BUT_SELFCHECK_OK,           /* 2 */
   DIA_EN_ERROR_CODE_CHECK_CANT_BE_EXECUTED,    /* e.g. no communication to V850 */    /* 3 */
   DIA_EN_ERROR_CODE_NO_CHECKSUM_FILE_DIRECTORY,                                       /* 4 */
   DIA_EN_ERROR_CODE_NO_CHECKSUM_FILE,                                                 /* 5 */
   DIA_EN_ERROR_CODE_PARAMETER_ERROR,                                                  /* 6 */
   DIA_EN_ERROR_CODE_NO_VALID_BOOTCHAIN_FOUND,                                         /* 7 */
   DIA_EN_ERROR_CODE_OTHER_ERROR,                                                      /* 8 */
   DIA_EN_ERROR_CODE_NOT_APPLICABLE,                                                   /* 9 */
   DIA_EN_ERROR_CODE_COUNT
};


struct dia_chksum_attr
{
   const char* ModuleName;
   const char* AreaName;
   const char* ResultFileName;
};

extern dia_chksum_attr aDiaChkSumMapTable[DIA_EN_CAV_MEM_AREA_COUNT];

class dia_RoutineCtrlChecksum
   : public dia_Routine
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlChecksum);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlChecksum);

   friend class dia_InOutThreadParam;

public:
   //! Constructor to use standard script file
   dia_RoutineCtrlChecksum (tCString name, tU16 udsID, dia_eRoutineID routineID);
   //! Constructor to provide alternative script file
   dia_RoutineCtrlChecksum (tCString name, tU16 udsID, dia_eRoutineID routineID, tCString executable);
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );
   //! handle timeout from UDS session object
   virtual void vOnServiceTimeout ( void );

protected:

   //! @brief Get value from specified key (it searches for key="value")
   //! @return true if key found, otherwise false.
   virtual bool getVal(std::string& inLine, const char* key, std::string& outStrVal);

   inline void convertToLower(std::string& str) const;

   //! @brief  Send positive response for request routine results
   //! @param[in] inBuff  Input buffer for hash bytes. If NULL, send zeros.
   //! @param[in] routineResultInx  Index for first byte.
   //! @param[in] verificationResultInx  Index for last byte.
   virtual void vposResponse( std::vector<tU8>& results, tU8* inBuff, dia_eRoutineStatus routineResultInx, dia_eScriptErrorCode verificationResultInx );

   //! @brief Check if script exists.
   //! @return DIA_SUCCESS if script exists, otherwise DIA_FAILED.
   //virtual tDiaResult existScript(const tU8* fullPathScript);

   //! @brief Take string of checksum and convert it to byte array.
   //!        There is no need that input buffer of string must be null-terminated!
   //! @return DIA_SUCCESS on success, otherwise DIA_FAILED.
   //! @param[in] pInConfigHash  Input string of hex representation.
   //! @param[out] pOutConvertedStr  Output buffer for converted values. Minimum size is half of numCharsToBeConverted.
   //! @param[in] numCharsToBeConverted  Number of characters to be converted. The value must be odd.
   virtual tDiaResult convertString ( const tU8* pInConfigHash, tU8* pOutConvertedStr, tU8 numCharsToBeConverted );

   //! @brief Start script for checksum calculation.
   //! @return DIA_SUCCESS on success, otherwise DIA_FAILED (semaphore locked).
   //! @param[in] diag_area Type of area
   virtual tDiaResult startScript ( const dia_eCAV_Mem_Area diag_area);

   //! @brief Parse checksum report file (path hard coded) and send response in case of success (return DIA_SUCCESS).
   //!        This function returns DIA_E_ROUTINE_NOT_COMPLETE when at least one of following conditions is met.
   //!         1/ checksum hash cannot be found in checksum report,
   //!         2/ return code cannot be found in checksum report,
   //!         3/ cookie strings do not match.
   //! @return DIA_SUCCESS on success, otherwise DIA_E_BUSY_REPEAT or DIA_E_ROUTINE_NOT_COMPLETE.
   //! @param[in]  pInMapTable Pointer to array for checksum variables
   //! @param[in]  pInPathReport Path to directory where comparison report is located
   //! @param[out] pOutBuffRespConvStr Output buffer for array of converted values
   //!             Length of the output buffer is DIA_CHECKSUM_SIZE_OF_CHECKSUM_IN_CHARS.
   //! @param[out] pOutVerificationResult Pointer to write result code (e.g. "Code="1"")
   virtual tDiaResult parseReport(dia_chksum_attr* pInMapTable, const char* pInPathReport, tU8* pOutBuffRespConvStr, tU32 outBuffSize, tU8* pOutVerificationResult);

   //! @brief Start new thread for checksum calculation
   //! @return DIA_SUCCESS if thread started successfully, otherwise DIA_FAILED.
   //! @see vThreadEntry()
   virtual tDiaResult vThreadRequest(void);

   //! @brief Set full path to script
   static void setFullPathScript(tU8* newFullPathScript) { sFullPathScript = newFullPathScript; }

protected:

   //! active object with input/output parameters for thread
   dia_InOutThreadParam mInOutParam;

   //! Full path to script that should be run.
   static tU8* sFullPathScript;

   //! DID from sent request
   tU16 mDID;

   //! thread identifier
#ifndef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
   OSAL_tThreadID mThreadID;
#else
   pthread_t mThreadID;
#endif
};

#endif /* DIA_ROUTINECTRLCHECKSUM_H_ */
