/*
 * dia_RoutineCtrlCalculateRoute.h
 *
 *  Created on: 22.11.2012
 *      Author: bhs1hi
 */

#ifndef DIA_ROUTINECTRLCALCULATEROUTE_H_
#define DIA_ROUTINECTRLCALCULATEROUTE_H_

#ifndef __INCLUDED_DIA_ROUTINE_LONGTERM__
#include "common/framework/protocols/uds/rtctrl/dia_RoutineLong.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_NAVIGATION_LISTENER__
#include "common/interfaces/dia_INavigationListener.h"
#endif

class dia_RoutineCtrlCalculateRoute
   : public dia_RoutineLong,
     public dia_INavigationListenerImpl
{
   DECL_DEFAULT_CONSTRUCTOR_AND_DESTRUCTOR(dia_RoutineCtrlCalculateRoute);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_RoutineCtrlCalculateRoute);

public:
   //! start the specified routine
   virtual tDiaResult start ( std::vector<tU8>& params, tU8 timerValue=DIA_C_U8_UDS_RTCTRL_TIMER_VALUE_INFINITE ); //lint !e1735 Info: verified that same default parameter is used as in base class
   //! return control back to the ECU for the specified signal
   virtual tDiaResult requestResult ( std::vector<tU8>& results );

   //! handle timeout from UDS session object
   virtual tVoid vOnServiceTimeout ( tVoid );

   //! route calculation is started
   virtual tVoid vOnRouteCalculationStarted ( tDiaResult result );
   //! route calculation procedure is finished
   virtual tVoid vOnRouteCalculationStatus ( tU8 u8RouteCalculationStatus,
	                                         tU32 u32RouteLength, 
										     tU32 u32RouteDuration );
protected:

	//! set start and destination geo co-ordinates
	tDiaResult setCMGeoCoordinates(std::vector<tU8>& params);
	//! request result status
	tDiaResult requestResultStatus( tVoid );
};

#endif /* DIA_ROUTINECTRLCALCULATEROUTE_H_ */

