/*
 * dia_ReadBluetoothMACAddress.h
 *
 *  Created on: 20.09.2013
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_READ_BTMACADDRESS_H_
#define __INCLUDED_DIA_READ_BTMACADDRESS_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include "common/framework/application/dia_Factory.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
#include "common/interfaces/dia_IBluetoothListener.h"
#endif

class dia_ReadBluetoothMACAddress
   : public dia_ServiceHandlerUDS,
     public dia_IBluetoothListenerImpl
{
   	DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_ReadBluetoothMACAddress);


public:
   //! class constructor
   	dia_ReadBluetoothMACAddress ( void );

	/**
	  * \brief    	handle the received request
	  *
	  *				Function receives the message via the oDiagMsgBuffer and send it to the SA.
	  *				The SystemAdapter returns the BT MAC-Adress.
	  *
	  * \param[in]	void*     -
	  * \param[in]	void*     -
	  */
	virtual void vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ );

	/**
	  * \brief    	status for the requested BT MAC-Address
	  *
	  *				Function recieves the message via its parameter and send it to the tester.
     *				It verifies the SA answer and send the expected value to the tester.
	  *
	  * \param[in]	midw_ext_fi_tclString btDeviceAddr	BT Device Name String
	  * \param[in]	tU32 btDeviceAddr_size length of btDeviceAddr
	  */
	virtual void vOnBTMACAddressResponse ( char* btDeviceAddr, tU32 btDeviceAddr_size );


protected:
	//! class destructor
	virtual ~dia_ReadBluetoothMACAddress(void);

};


#endif /* __INCLUDED_DIA_READ_BTMACADDRESS_H_ */
