/*
 * dia_ReadBluetoothMACAddress.cpp
 *
 *  Created on: 20.09.2013
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 04 22 70 08

#include "common/services/uds/production/dia_ReadBluetoothMACAddress.h"

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

using namespace dia_nsUtilities;

#define DATA_START 3
#define DATA_LENGTH 17

//-----------------------------------------------------------------------------

dia_ReadBluetoothMACAddress::dia_ReadBluetoothMACAddress ( void )
    : dia_ServiceHandlerUDS("dia_ReadBluetoothMACAddress",DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,(tU16) DIA_C_U16_DID_RBCM_BT_MAC_ADDRESS /*DID*/)
{
   dia_tclFnctTrace trc("dia_ReadBluetoothMACAddress::dia_ReadBluetoothMACAddress(void)");
}

//-----------------------------------------------------------------------------

dia_ReadBluetoothMACAddress::~dia_ReadBluetoothMACAddress( void )
{
    _BP_TRY_BEGIN
    {
       (void) unsetSysAdapterListener<dia_IBluetoothListener>(this);
    }
    _BP_CATCH_ALL
    {
        DIA_TR_ERR("EXCEPTION CAUGHT: dia_ReadBluetoothMACAddress::~dia_ReadBluetoothMACAddress !!!");
        DIA_ASSERT_ALWAYS();
    }
    _BP_CATCH_END
}

//-------------------------------------------------------------------------------

void
dia_ReadBluetoothMACAddress::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_ReadBluetoothMACAddress::vProcessRequest");

   tBool errorDetected = TRUE;

   dia_IBluetooth* pBluetooth = 0;
   if ( querySysAdapterInterface<dia_IBluetooth>(&pBluetooth) == DIA_SUCCESS )
   {
      if ( pBluetooth )
      {
         (void) setSysAdapterListener<dia_IBluetoothListener>(this);
         if ( pBluetooth->getBTMACAddress() == DIA_SUCCESS )
         {
            errorDetected = FALSE;
            DIA_TR_INF("dia_ReadBluetoothMACAddress - getBTMACAddress SUCCESS!");
         } else {
            DIA_TR_INF("dia_ReadBluetoothMACAddress - getBTMACAddress FAILED!");
         }
      }
   }

   if ( errorDetected )
   {
      (void) unsetSysAdapterListener<dia_IBluetoothListener>(this);
      DIA_TR_ERR("dia_ReadBluetoothMACAddress --- SEND TO BLUETOOTH SA FEATURE FAILED!!!!");
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//-----------------------------------------------------------------------------

void
dia_ReadBluetoothMACAddress::vOnBTMACAddressResponse ( char* btDeviceAddr, tU32 btDeviceAddr_size )
{
   dia_tclFnctTrace trc("dia_ReadBluetoothMACAddress::vOnBTMACAddressResponse");

   if ( (btDeviceAddr_size == 18) && (btDeviceAddr[0] != 0) )  // size 18 means 17B + '\0'
   {
      // Sending back the positive answer
      oDiagMsgBuffer().vSetPosResp();
      oDiagMsgBuffer().vSetDataLength(DATA_START + DATA_LENGTH);
      for(tU8 i=0; i<DATA_LENGTH; i++){
         tU8 hex_value = (tU8)((dia_nsUtilities::getBinaryFromHexString(btDeviceAddr[i*3]) * 0x10) + dia_nsUtilities::getBinaryFromHexString(btDeviceAddr[(i*3)+1]));
         DIA_TR_INF("dia_ReadBluetoothMACAddress::vOnBTMACAddressResponse at %d value = 0x%02x .", i, hex_value);
         (void) oDiagMsgBuffer().vSetDataU8(static_cast<tU16>(DATA_START + i), hex_value);
      }

      (void) unsetSysAdapterListener<dia_IBluetoothListener>(this);
      vResReadyAndQuit();
      DIA_TR_INF("dia_ReadBluetoothMACAddress::vOnBTMACAddressResponse SUCCESSFUL");
   }
   else {
      DIA_TR_INF("dia_ReadBluetoothMACAddress::vOnBTMACAddressResponse FAIL");
      // Sending back the Negative answer
      vSendNegativeResponse(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   }
}
