/**
 * \file      dia_ReadBluetoothLinkQuality.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      22.10.2012
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#define DIA_MCN_BT_LINKQUALITY_TIMEOUT   20000

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#include "dia_ReadBluetoothLinkQuality.h"

#define DATA_START ((tU8) 3)

//------------------------------------------------------------------------------

dia_ReadBluetoothLinkQuality::dia_ReadBluetoothLinkQuality ( tVoid )
   : dia_ServiceHandlerUDS("dia_ReadBluetoothLinkQuality", DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER, DIA_C_U16_DID_RBCM_BLUETOOTH_LINK_QUALITY) //,
//     mIsValid(FALSE),
//     mLinkQuality(0),
//     mRSSI(0)
{
   dia_tclFnctTrace oTrace("dia_ReadBluetoothLinkQuality::dia_ReadBluetoothLinkQuality()");
//
//   // create the state machine object
//   pBTLinkQualityFSM = OSAL_NEW dia_BluetoothLinkQualityFSM::Fsm(this);
//
//   setSysAdapterListener<dia_IBluetoothListener>(this);
}

//------------------------------------------------------------------------------

dia_ReadBluetoothLinkQuality::~dia_ReadBluetoothLinkQuality ( tVoid )
{
   _BP_TRY_BEGIN
   {
//      OSAL_DELETE pBTLinkQualityFSM;
//      pBTLinkQualityFSM = 0;
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_ReadBluetoothLinkQuality::~dia_ReadBluetoothLinkQuality !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

//   // make lint happy
//   pBTLinkQualityFSM = 0;
}

//------------------------------------------------------------------------------

//tVoid
//dia_ReadBluetoothLinkQuality::vInit ( tVoid )
//{
//    if ( pBTLinkQualityFSM ) pBTLinkQualityFSM->init();
//}

//------------------------------------------------------------------------------

tVoid
dia_ReadBluetoothLinkQuality::vOnTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_ReadBluetoothLinkQuality::vOnTimeout");
   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
   oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
   vResReadyAndQuit();

}

//------------------------------------------------------------------------------

tU32
dia_ReadBluetoothLinkQuality::u32MaxPgTime ( tVoid ) const
{
    return DIA_MCN_BT_LINKQUALITY_TIMEOUT;
}

//------------------------------------------------------------------------------

tVoid
dia_ReadBluetoothLinkQuality::vProcessRequest ( const std::vector<tArgsType>& /*vecArgs*/ )
{
   dia_tclFnctTrace trc("dia_ReadBluetoothLinkQuality::vProcessRequest");

   tDiaResult errCode = DIA_FAILED;

   dia_IBluetooth* pBT = 0;
   if ( (querySysAdapterInterface<dia_IBluetooth>(&pBT) == DIA_SUCCESS) && pBT )
   {
      (tVoid) setSysAdapterListener<dia_IBluetoothListener>(this);
      errCode = pBT->measureLinkQuality();
   }

   if ( errCode != DIA_SUCCESS )
   {
      (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);
      oDiagMsgBuffer().vSetNegResp(DIA_E_U8_UDS_CONDITIONS_NOT_CORRECT);
      vResReadyAndQuit();
   }
}

//----------------------------------------------------------------------------------------

tVoid
dia_ReadBluetoothLinkQuality::vOnBTLinkQuality ( tU8 linkQuality, tS8 RSSI, tBool isValid )
{
   dia_tclFnctTrace trc("dia_ReadBluetoothLinkQuality::vOnBTLinkQuality");

   DIA_TR_INF("dia_ReadBluetoothLinkQuality: LinkQuality = %d, RSSI = %d, Validity = %d", linkQuality, RSSI, ((isValid) ? 1 : 0));

//   mLinkQuality = LinkQuality;
//   mRSSI = RSSI;
//   mIsValid = isValid;

//   if ( pBTLinkQualityFSM ) pBTLinkQualityFSM->acceptEvent(dia_BluetoothLinkQualityFSM::evLinkInfoStatus,0);

   (tVoid) unsetSysAdapterListener<dia_IBluetoothListener>(this);

   oDiagMsgBuffer().vSetPosResp();
   oDiagMsgBuffer().vSetDataLength(DATA_START + 2);
   (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START+0,(tU8) RSSI);
   (tVoid) oDiagMsgBuffer().vSetDataU8(DATA_START+1,(tU8) linkQuality);
   vResReadyAndQuit();
}
