/*
 * dia_IOCtrlWifiModuleReset.h
 *
 *  Created on: 27.10.2015
 *      Author: sbr5kor
 * The system shall provide tester the ability to reset the BT and Wifi module.
 */

#ifndef DIA_IOCTRL_WIFI_MODULE_RESET_H_
#define DIA_IOCTRL_WIFI_MODULE_RESET_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "common/framework/config/dia_defsConfig.h"
#endif

class dia_IOCtrlWifiModuleReset
   :  public dia_IOCtrlSignal
{
public:
   //! class constructor
   dia_IOCtrlWifiModuleReset ( void );
   //! class destructor
   virtual ~dia_IOCtrlWifiModuleReset ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual void handleTimeout ( void );

protected:
   //! reset BT/Wifi module
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! reset Wifi module
   tDiaResult resetWifiModule ( const tU8 ctrlValue ) const;

};

#endif /* DIA_IOCTRL_WIFI_MODULE_RESET_H_ */
