/*
 * dia_IOCtrlWifiModuleReset.cpp
 *
 *  Created on: 27.10.2015
 *      Author: sbr5kor
//TTFis:> DIA_REQ UDS 07 2F 63 62 03 01
 *                                  (01..FF) -> Reset BT/Wifi
 *                                  (00)     -> Normal
 *      ---------------------------------------------------------------------------------------------------------------------
 *      Date        Author	    Modification
 *      28.12.2015  bsu9kor		Added Header Guards and new header files
 *		28.12.2015  bsu9kor		Added code snippet to access GPIO Pin 37 (AIVI-15299)
 *		28.12.2015  bsu9kor		Added code modification to handle return control to ECU (AIVI-15299)
 *      ---------------------------------------------------------------------------------------------------------------------
 */
#ifndef DIA_IOCTRL_WIFI_MODULE_RESET_H_
#include "common/services/uds/production/dia_IOCtrlWifiModuleReset.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

#include <unistd.h> //lint !e451 !e537 repeatedly included header file without standard include guard

#define CTRL_VALUE_SIZE 1
#define DATA_LENGTH 3

#define WIFI_MODULE_STATUS_RESET   0x00
#define WIFI_MODULE_STATUS_NORMAL  0x01
#define WIFI_MODULE_STATUS_UNKNOWN 0xFF

#ifdef __ENABLE_WIFIMODULE_OSAL_DEFINE__
#define DIA_PROP_GPIO_WIFI_MODULE_RESET_SIZE 0x01
#endif
//------------------------------------------------------------------------------

dia_IOCtrlWifiModuleReset::dia_IOCtrlWifiModuleReset ( void )
   : dia_IOCtrlSignal (
		 "dia_IOCtrlWifiModuleReset",
		 DIA_C_U16_DID_RBCM_WIFI_MODULE_RESET,
		 CTRL_VALUE_SIZE // Length in Byte
        )
{
}
//------------------------------------------------------------------------------

dia_IOCtrlWifiModuleReset::~dia_IOCtrlWifiModuleReset ( void )
{
}
//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlWifiModuleReset::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlWifiModuleReset::handleRequest()");
   tU8 resetStatus = WIFI_MODULE_STATUS_NORMAL;
   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("dia_IOCtrlWifiModuleReset::handleRequest ctrlValue->size() = %zu .", ctrlValue->size());

   switch(ctrlValue->at(0)){
      case 0x00:
    	  resetStatus = WIFI_MODULE_STATUS_NORMAL;
          DIA_TR_INF("dia_IOCtrlWifiModuleReset::handleRequest resetStatus 0x%02x.", ctrlValue->at(0));
          break;
      case 0x01:
    	  resetStatus = WIFI_MODULE_STATUS_RESET;
          DIA_TR_INF("dia_IOCtrlWifiModuleReset::handleRequest resetStatus 0x%02x.", ctrlValue->at(0));
          break;
      default:
    	  DIA_TR_INF("dia_IOCtrlWifiModuleReset::handleRequest default resetStatus 0x%02x !", ctrlValue->at(0));
    	  resetStatus = WIFI_MODULE_STATUS_UNKNOWN;
          break;
   }
   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);
   mIsResultReady = FALSE;

   if (resetStatus != WIFI_MODULE_STATUS_UNKNOWN)
   {
	   // Reset Wifi
	   if (resetWifiModule (resetStatus) == DIA_SUCCESS)
	   {
		   mIsResultReady = TRUE;
		   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
	   }
	   else
	   {
		   retCode = DIA_FAILED;
	   }
   }
   else
   {
	   DIA_TR_INF("dia_IOCtrlWifiModuleReset::handleRequest default resetStatus WIFI_MODULE_STATUS_UNKNOWN");
	   retCode = DIA_FAILED;
   }

   // NO_ERROR allows the service handler to return immediately
   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlWifiModuleReset::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlWifiModuleReset::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( (status == DIA_EN_IOCTRL_STATUS_INACTIVE) || (status == DIA_EN_IOCTRL_STATUS_INACTIVE_TIMEOUT))
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
         status = DIA_EN_IOCTRL_STATUS_INACTIVE;
      }
      // Reset BT/Wifi to normal
      if (resetWifiModule (WIFI_MODULE_STATUS_NORMAL) == DIA_SUCCESS)
      {
    	  mIsResultReady = TRUE;
    	  DIA_TR_INF("dia_IOCtrlWifiModuleReset::vOnTerminate(): ABLE TO WRITE GPIO data");
      }
      else
      {
    	  retCode = DIA_E_ERROR;
    	  DIA_TR_INF("dia_IOCtrlWifiModuleReset::vOnTerminate(): UNABLE TO WRITE GPIO data");
    	  setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      }

   }
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
   // this ioctrl is controlled by the external tester
   eSetMode(DIA_EN_IOCTRL_CTRLMODE_ECU);

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}
//-----------------------------------------------------------------------------

void
dia_IOCtrlWifiModuleReset::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlWifiModuleReset::handleTimeout");
}
//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlWifiModuleReset::resetWifiModule ( const tU8 ctrlValue ) const
{
	tDiaResult retCode = DIA_FAILED;
#if defined(__ENABLE_WIFIMODULE_SYS_PATH__)
   dia_tclFnctTrace trc("dia_IOCtrlWifiModuleReset::resetWifiModule");
   FILE *fd;
   tU16 error_code = 0;

   DIA_TR_INF("Performing reset cycle of the Wifi chip...");

   DIA_TR_INF("enabling the GPIO reset line");

   fd = fopen("/sys/class/gpio/export", "wb");

   if (fd == NULL) {
	   error_code = 1;
	   DIA_TR_INF("Reset cycle failed with code: %d", error_code);
	   return retCode;
   }

   fwrite("37", sizeof(char), 3, fd);

   fclose(fd);

   DIA_TR_INF("setting GPIO direction to output");

   fd = fopen("/sys/class/gpio/gpio37/direction", "wb");

   if (fd == NULL) {
      	error_code = 2;
      	DIA_TR_INF("Reset cycle failed with code: %d", error_code);
      	return retCode;
   }

   fwrite("out", sizeof(char), 3, fd);

   fclose(fd);

   fd = fopen("/sys/class/gpio/gpio37/value", "wb");

   if (fd == NULL) {
      	error_code = 3;
      	DIA_TR_INF("Reset cycle failed with code: %d", error_code);
      	return retCode;
   }

   if(ctrlValue == WIFI_MODULE_STATUS_RESET){
	   DIA_TR_INF("setting GPIO reset line to LOW for Reset");
	   retCode = DIA_SUCCESS;
	   DIA_TR_INF("RESETTING WIFI MODULE");
       fwrite("0", sizeof(char), 1, fd);
   }
   else if (ctrlValue == WIFI_MODULE_STATUS_NORMAL){
	   DIA_TR_INF("setting GPIO reset line to HIGH for Normal");
	   retCode = DIA_SUCCESS;
	   DIA_TR_INF("UNRESETTING WIFI MODULE");
	   fwrite("1", sizeof(char), 1, fd);
   }
   else{
	   DIA_TR_INF("Setting GPIO reset Line failed");
   }
   fclose(fd);

   DIA_TR_INF("keep reset High for 100ms then performs usal intialization by doing one more reset");
   usleep(100000); // DiagOmitSleepWarning

#elif defined(__ENABLE_WIFIMODULE_OSAL_DEFINE__)
   dia_tclFnctTrace trc("dia_IOCtrlWifiModuleReset::resetWifiModule");

   retCode = DIA_SUCCESS;
   tU16 size = dia_getPropertySize(DIA_PROP_GPIO_WIFI_MODULE_RESET);
   tU8 data[DIA_PROP_GPIO_WIFI_MODULE_RESET_SIZE] = {0};

   data[OSAL_NULL] = ctrlValue;

   // write System Amp On Output
   if (DIA_SUCCESS != dia_setProperty(DIA_PROP_GPIO_WIFI_MODULE_RESET, data, size))
   {
	   retCode = DIA_FAILED;
	   DIA_TR_INF("dia_IOCtrlWifiModuleReset::resetWifiModule(): UNABLE TO WRITE GPIO data");
   }
#else
    DIA_PARAMETER_INTENTIONALLY_UNUSED(ctrlValue);
#endif
	   return retCode;
}
