/*
 * dia_IOCtrlWifiMode.h
 *
 *  Created on: 04.02.2019
 *      Author: kaa1hi
 */
/*
 * The system shall implement a diagnostic service IOControl audioLinearMode to provide the diagnostic tester the ability to control the status of the audio linear mode.
 * If the audio linear mode has been activated, the system shall set all sound processing measures or parameters to a linear or fixed specified value. The linear mode shall
 * be implemented in a way that it is suitable as reference for production tests.
 */

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_WIFI_SETUPS_LISTENER__
#include "common/interfaces/dia_IWifiSetupsListener.h"
#endif

#ifndef DIA_DIA_IOCTRLWIFIMODE_H_
#define DIA_DIA_IOCTRLWIFIMODE_H_


class dia_IOCtrlWifiMode
   : public dia_IOCtrlSignal,
     public dia_IWifiSetupsListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlWifiMode ( void );
   //! class destructor
   virtual ~dia_IOCtrlWifiMode ( void );

   //! handle set request
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //! handle timeout
   virtual void handleTimeout ( void );


   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IWifiSetupsListener methods
   //
   //-------------------------------------------------------------------------

   //! Response for request 'prepare Setup'
   virtual void onPrepareSetup (tDiaResult response );

   //! Response for request 'DeActivate Setup'
   virtual void onDeActivateSetup (tDiaResult response );

protected:
   //! switch off the wifi mode request
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   //! set Wifi mode (activate)
   virtual tDiaResult setWifiMode ( const std::string& mode );

   //! unset Wifi mode (deactivate)
   virtual tDiaResult unsetWifiMode ( const std::string& mode );

private:
   const std::map<tU8, dia_enWifiMode > mMapByteToWifiMode =
   {
      { 0, DIA_ENUM_WIFI_MODE_OFF_STA  },
      { 1, DIA_ENUM_WIFI_MODE_STA      },
      { 2, DIA_ENUM_WIFI_MODE_AP       }
   };

   const std::map<dia_enWifiMode, const std::string > mMapWifiModeToString =
   {
      {DIA_ENUM_WIFI_MODE_OFF_STA,  "STA" },
      {DIA_ENUM_WIFI_MODE_STA,      "STA" }
   };

   //! wifi mode in last IO Ctrl request
   std::string mLastWifiMode;

   //! size of input parameter
   static const tU32 IOCTRL_WIFI_MODE_PARAMETER_SIZE;
};

#endif /* DIA_DIA_IOCTRLWIFIMODE_H_ */
