/*
 * dia_IOCtrlTunerXM_1_Channel.cpp
 *
 *  Created on: 30.10.2012
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 06 2F 61 40 03 01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlTunerXM_1_Channel.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//#define DATA_START 3
//#define DATA_LENGTH 2
#define CTRL_VALUE_SIZE 1

//------------------------------------------------------------------------------

dia_IOCtrlTunerXM_1_Channel::dia_IOCtrlTunerXM_1_Channel(tVoid) :
   dia_IOCtrlSignalRestrictedToRemoteControl(
		    DIA_C_U16_DID_RBCM_SXM_TUNER_CHANNEL,
            DIA_EN_IOCTRL_SIGTYPE_TUNERXM_1_Channel,
            CTRL_VALUE_SIZE /* Payload Length */
            )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlTunerXM_1_Channel::~dia_IOCtrlTunerXM_1_Channel(tVoid)
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerXMControlListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlTunerXM_1_Channel::~dia_IOCtrlTunerXM_1_Channel !!!");
      DIA_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

 //------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerXM_1_Channel::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerXM_1_Channel::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;

   dia_ITunerXMControl* pInterface = 0;
   if (querySysAdapterInterface<dia_ITunerXMControl>(&pInterface) == DIA_SUCCESS) {
      DIA_TR_INF("dia_IOCtrlTunerXM_1_Channel::handleRequest - querySysAdapterInterface OK.");
      if (pInterface) {

         (tVoid) setSysAdapterListener<dia_ITunerXMControlListener>(this);
         DIA_TR_INF("dia_IOCtrlTunerXM_1_Channel::handleRequest - set channel 0x%02x.",ctrlValue->at(0));
         if (pInterface->TunerXMControl_1_Channel_Set(ctrlValue->at(0)) == DIA_SUCCESS) {
            errorDetected = FALSE;
            DIA_TR_INF("dia_IOCtrlTunerXM_1_Channel::handleRequest - TunerXMControl_1_Channel_Set OK.");
         } else {
            DIA_TR_INF("dia_IOCtrlTunerXM_1_Channel::handleRequest - TunerXMControl_1_Channel_Set FAILED.");
         }
      } else {
         DIA_TR_INF("dia_IOCtrlTunerXM_1_Channel::handleRequest - pInterface FAILED.");
      }
   } else {
      DIA_TR_INF("dia_IOCtrlTunerXM_1_Channel::handleRequest - querySysAdapterInterface FAILED.");
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ITunerXMControlListener>(this);
      DIA_TR_ERR(" ---  SEND TO XM TUNER SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerXM_1_Channel::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerXM_1_Channel::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_ITunerXMControl* pInterface = 0;
      if (querySysAdapterInterface<dia_ITunerXMControl>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_ITunerXMControlListener>(this);
            if (pInterface->TunerXMControl_1_Channel_Set(0x00) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET XM TUNER CHANNEL !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_IOCtrlTunerXM_1_Channel::vOnTunerXMControl_1_Channel_Set ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerXM_1_Channel::vOnTunerXMControl_1_Channel_Set");
   
   (tVoid) unsetSysAdapterListener<dia_ITunerXMControlListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlTunerXM_1_Channel::vOnTunerXMControl_1_Channel_Set SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlTunerXM_1_Channel::vOnTunerXMControl_1_Channel_Set DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid dia_IOCtrlTunerXM_1_Channel::handleTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerXM_1_Channel::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_ITunerXMControlListener>(this);
}


