/*
 * dia_IOCtrlTunerDRM_Antenna_ServiceID.cpp
 *
 *  Created on: 21-09-2015
 *      Author: nce5kor
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "../../../depricated/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "../../../depricated/dia_main.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#include "dia_IOCtrlTunerDRM_Antenna_ServiceID.h"

//-----------------------------------------------------------------------------

dia_IOCtrlTunerDRM_Antenna_ServiceID::dia_IOCtrlTunerDRM_Antenna_ServiceID(tVoid) :
          dia_IOCtrlSignalRestrictedToRemoteControl(
          DIA_C_U16_DID_RBCM_TUNER_DRM_SERVICE_ID,
          DIA_EN_IOCTRL_SIGTYPE_TUNERDRM_ANT_SERVICE_ID,
          4 /* Payload */
      )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_ServiceID::dia_IOCtrlTunerDRM_Antenna_ServiceID");
}

//-----------------------------------------------------------------------------

dia_IOCtrlTunerDRM_Antenna_ServiceID::~dia_IOCtrlTunerDRM_Antenna_ServiceID ( tVoid )
{
//   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_ServiceID::~dia_IOCtrlTunerDRM_Antenna_ServiceID");

   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR( ("EXCEPTION CAUGHT: dia_IOCtrlTunerDRM_Antenna_ServiceID::~dia_IOCtrlTunerDRM_Antenna_ServiceID !!!") );
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerDRM_Antenna_ServiceID::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_ServiceID::handleRequest");
   tBool errorDetected = TRUE;

   tU32 serviceID = U8_2_U32(ctrlValue->at(0),ctrlValue->at(1),ctrlValue->at(2),ctrlValue->at(3)); //lint !e864 Info: expression possibly depends on order of evaluation

   DIA_TR_INF("dia_IOCtrlTunerDRM_Antenna_ServiceID::handleRequest serviceID = 0x%04x",serviceID);
   dia_ITunerAMFM* pInterface = 0;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);
         if (pInterface->tunerDRM_ServiceID_Set(serviceID) == DIA_SUCCESS) {
            DIA_TR_INF("dia_IOCtrlTunerDRM_Antenna_ServiceID::handleRequest: PowerMode_Set SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_IOCtrlTunerDRM_Antenna_ServiceID::handleRequest: PowerMode_Set FAILED.");
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR("dia_IOCtrlTunerDRM_Antenna_ServiceID --- SEND TO TUNER DRM CONTROL FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tVoid dia_IOCtrlTunerDRM_Antenna_ServiceID::vOnTunerDRMServiceID_Set ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_ServiceID::vOnTunerDRMPowerSupply_Set");

   if (success == DIA_SUCCESS) {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      mIsResultReady = TRUE;
      DIA_TR_INF("dia_IOCtrlTunerDRM_Antenna_ServiceID::vOnTunerDRMPowerSupply_Set SUCCESS.");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlTunerDRM...ServiceID::vOnTunerDRMPowerSupply_Set NEGATIVE RESULT FROM SA!!!");
   }
   
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//----------------------------------------------------------------------------------------

tVoid dia_IOCtrlTunerDRM_Antenna_ServiceID::vOnTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_ServiceID::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult dia_IOCtrlTunerDRM_Antenna_ServiceID::vOnTerminate(dia_eIOCtrlStatus /*status*/)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerDRM_Antenna_ServiceID::vOnTerminate()");

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return DIA_E_NOERROR;
}
