/*
 * dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency.cpp
 *
 *  Created on: 21-09-2015
 *      Author: nce5kor
 *------------------------------------------------------------------------------------------
 * Date         Author         Modification
 * 10.02.16	    bsu9kor		   Added code to convert frequency from Hz to KHz(SUZUKI-27972)
 *
 *--------------------------------------------------------------------------------------------
 */


#ifndef __INCLUDED_DIA_COMMON__
#include "../../../depricated/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "../../../depricated/dia_main.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#include "dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency.h"

#define FREQ_KHZ 1000
//-----------------------------------------------------------------------------

dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency(tVoid) :
          dia_IOCtrlSignalRestrictedToRemoteControl(
          DIA_C_U16_DID_RBCM_TUNER_DRM_ENSEMBLE_FREQUENCY,
          DIA_EN_IOCTRL_SIGTYPE_TUNERDRM_ANT_ENSEMBLE_FREQUENCY,
          4 /* Payload */
      )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency");
}

//-----------------------------------------------------------------------------

dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::~dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR( ("EXCEPTION CAUGHT: dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::~dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency !!!") );
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::handleRequest");
   tBool errorDetected = TRUE;

   tU32 frequency = U8_2_U32(ctrlValue->at(0),ctrlValue->at(1),ctrlValue->at(2),ctrlValue->at(3)); //lint !e864 Info: expression possibly depends on order of evaluation

   frequency = frequency/FREQ_KHZ;// convert: CANoe sends in Hz <-> FI expects kHz
   DIA_TR_INF("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::handleRequest frequency = 0x%04x",frequency);
   dia_ITunerAMFM* pInterface = 0;
   if (querySysAdapterInterface<dia_ITunerAMFM>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (tVoid) setSysAdapterListener<dia_ITunerAMFMListener>(this);
         if (pInterface->tunerDRM_EnsembleFrequency_Set(frequency) == DIA_SUCCESS) {
            DIA_TR_INF("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::handleRequest: PowerMode_Set SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_ERR("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::handleRequest: PowerMode_Set FAILED.");
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      DIA_TR_ERR("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency --- SEND TO TUNER DRM CONTROL FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;

}

//----------------------------------------------------------------------------------------

tVoid
dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::vOnTunerDRMEnsembleFrequency_Set ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::vOnTunerDRMPowerSupply_Set");

   if (success == DIA_SUCCESS) {
      (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
      mIsResultReady = TRUE;
      DIA_TR_INF("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::vOnTunerDRMPowerSupply_Set SUCCESS.");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlTunerDRM...EnsembleFrequency::vOnTunerDRMPowerSupply_Set NEGATIVE RESULT FROM SA!!!");
   }
   
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//----------------------------------------------------------------------------------------

tVoid
dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::vOnTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_ITunerAMFMListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::vOnTerminate(dia_eIOCtrlStatus /*status*/)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerDRM_Antenna_EnsembleFrequency::vOnTerminate()");

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return DIA_E_NOERROR;
}
