/*
 * dia_IOCtrlTunerDAB_Antenna_1_PowerSupply.cpp
 *
 *  Created on: 15.10.2012
 *      Author: shw2abt
 */
// TTFis:> DIA_REQ UDS 06 2F 61 31 03 00

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#include "dia_IOCtrlTunerDAB_Antenna_1_PowerSupply.h"

//-----------------------------------------------------------------------------

dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::dia_IOCtrlTunerDAB_Antenna_1_PowerSupply(tVoid) :
      dia_IOCtrlSignal(
          DIA_C_U16_DID_RBCM_TUNER_DAB_POWER_SUPPLY,
          DIA_EN_IOCTRL_SIGTYPE_TUNERDAB_ANT1_POWER_SUPPLY,
          1 /* Payload */
      )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::dia_IOCtrlTunerDAB_Antenna_1_PowerSupply");
}

//-----------------------------------------------------------------------------

dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::~dia_IOCtrlTunerDAB_Antenna_1_PowerSupply ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::~dia_IOCtrlTunerDAB_Antenna_1_PowerSupply !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest");
    tBool errorDetected = TRUE;

    dia_eTunerMasterControlEnableMode powerMode = DIA_EN_TUNERMASTERCONTROL_MODE_UNKNOWN;

   for(tU8 i=0; i<ctrlValue->size(); i++){
      DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest input[%d] (0x%02x)",i,ctrlValue->at(i));
   }

   switch (ctrlValue->at(0)) {
   case 0x00:
      powerMode = DIA_EN_TUNERMASTERCONTROL_MODE_DISABLED;
      DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest POWER_OFF. (0x%02x)",ctrlValue->at(0));
      break;

   case 0x01:
      powerMode = DIA_EN_TUNERMASTERCONTROL_MODE_ENABLED;
      DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest POWER_ON. (0x%02x)",ctrlValue->at(0));
      break;

   default:
      DIA_TR_ERR("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest UNKNOWN POWER MODE!");
      break;
   } //lint !e788: not all items intentionally used within defaulted switch

   if (powerMode != DIA_EN_TUNERMASTERCONTROL_MODE_UNKNOWN) {
      dia_ITunerMasterControl* pInterface = 0;
      if (querySysAdapterInterface<dia_ITunerMasterControl>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_ITunerMasterControlListener>(this);
            if (pInterface->tunerDAB_TunerPowerSupply_Set(powerMode) == DIA_SUCCESS) {
               DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest: PowerMode_Set SUCCESS.");
               errorDetected = FALSE;
            } else {
               DIA_TR_ERR("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleRequest: PowerMode_Set FAILED.");
            }
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
      DIA_TR_ERR("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply --- SEND TO TUNER MASTER CONTROL FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
      return DIA_SUCCESS;

}

//----------------------------------------------------------------------------------------

tVoid dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::vOnTunerDABPowerSupply_Set ( dia_eTunerMasterControlEnableMode powerMode )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::vOnTunerDABPowerSupply_Set");

   if (powerMode != DIA_EN_TUNERMASTERCONTROL_MODE_UNKNOWN && powerMode < DIA_EN_TUNERMASTERCONTROL_MODE_COUNT) {
      (tVoid) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
      mIsResultReady = TRUE;
      DIA_TR_INF("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::vOnTunerDABPowerSupply_Set SUCCESS.");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("DIA_IOCTRLTUNERDAB...POWERSUPPLY::vOnTunerDABPowerSupply_Set NEGATIVE RESULT FROM SA!!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//----------------------------------------------------------------------------------------

tVoid dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleTimeout(tVoid)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::vOnTerminate(dia_eIOCtrlStatus /*status*/)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerDAB_Antenna_1_PowerSupply::vOnTerminate()");

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return DIA_E_NOERROR;
}
