/*
 * dia_IOCtrlTunerAMFM_SelectActiveTuner.cpp
 *
 *  Created on: 15.10.2012
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 06 2F 61 00 03 00

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

#include "common/services/uds/production/dia_IOCtrlTunerAMFM_SelectActiveTuner.h"

//#define DATA_START 3
//#define DATA_LENGTH 2

//------------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_SelectActiveTuner::dia_IOCtrlTunerAMFM_SelectActiveTuner(void) :
   dia_IOCtrlSignalRestrictedToRemoteControl(
            DIA_C_U16_DID_RBCM_TUNER_AMFM_SELECT_ACTIVE_TUNER,
            DIA_EN_IOCTRL_SIGTYPE_TUNER_SEL_ACTIVE_TUNER_AMFM,
            1 /* Payload Length */
            )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_SelectActiveTuner::~dia_IOCtrlTunerAMFM_SelectActiveTuner(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlTunerAMFM_SelectActiveTuner::~dia_IOCtrlTunerAMFM_SelectActiveTuner !!!");
      DIA_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

 //------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerAMFM_SelectActiveTuner::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerAMFM_SelectActiveTuner::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;

   DIA_TR_INF("dia_IOCtrlTunerAMFM_SelectActiveTuner::handleRequest switch to tuner 0x%02x .", ctrlValue->at(0));
   dia_ITunerMaster* pInterface = 0;
   if (querySysAdapterInterface<dia_ITunerMaster>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         tU8 tuner = ctrlValue->at(0);

         dia_eTuner newTuner = DIA_EN_TUNERMASTER_UNKNOWN;
         switch(tuner){
         case 0x00:
            newTuner = DIA_EN_TUNERMASTER_1;
            break;
         case 0x01:
            newTuner = DIA_EN_TUNERMASTER_2;
            break;
         case 0x02:
            newTuner = DIA_EN_TUNERMASTER_3;
            break;
         case 0x03:
            newTuner = DIA_EN_TUNERMASTER_4;
            break;
         default:
            DIA_TR_ERR("dia_IOCtrlTunerAMFM_SelectActiveTuner::handleRequest UNKNOWN TUNER NUMBER.");
            break;
         }

         (void) setSysAdapterListener<dia_ITunerMasterListener>(this);
         if (pInterface->tunerAMFM_ActiveTuner_Set(newTuner) == DIA_SUCCESS) {
            DIA_TR_INF("dia_IOCtrlTunerAMFM_SelectActiveTuner::handleRequest: tunerAMFM_ActiveTuner_Set SUCCESS.");
            errorDetected = FALSE;
         } else {
            DIA_TR_INF("dia_IOCtrlTunerAMFM_SelectActiveTuner::handleRequest: tunerAMFM_ActiveTuner_Set FAILED.");
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
      DIA_TR_ERR("dia_IOCtrlTunerAMFM_SelectActiveTuner --- SEND TO TUNER MSTR SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult dia_IOCtrlTunerAMFM_SelectActiveTuner::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerAMFM_SelectActiveTuner::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_ITunerMaster* pInterface = 0;
      if (querySysAdapterInterface<dia_ITunerMaster>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (void) setSysAdapterListener<dia_ITunerMasterListener>(this);
            if (pInterface->tunerAMFM_ActiveTuner_Set(DIA_EN_TUNERMASTER_UNKNOWN) != DIA_SUCCESS) {
               DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECTAUDIOTRACK !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

void dia_IOCtrlTunerAMFM_SelectActiveTuner::vOnTunerAMFMActiveTuner_Set ( tDiaResult success  )
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_SelectActiveTuner::vOnTunerAMFMActiveTuner_Set");
   
   (void) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlTunerAMFM_SelectActiveTuner::vOnTunerAMFMActiveTuner_Set SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlTunerAMFM_SelectActiveTuner::vOnTunerAMFMActiveTuner_Set DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

void dia_IOCtrlTunerAMFM_SelectActiveTuner::handleTimeout(void)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_SelectActiveTuner::handleTimeout");
   (void) unsetSysAdapterListener<dia_ITunerMasterListener>(this);
}

