/*
 * dia_IOCtrlTunerAMFM_Antenna_PowerSupply.h
 *
 *  Created on: 15.10.2012
 *      Author: shw2abt
 */

#ifndef DIA_IOCTRLTUNERAMFM_ANTENNA_POWERSUPPLY_H_
#define DIA_IOCTRLTUNERAMFM_ANTENNA_POWERSUPPLY_H_


#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TUNERMASTERCONTROL_LISTENER__
#include "common/interfaces/dia_ITunerMasterControlListener.h"
#endif

enum dia_eAntennaNumber
{
   DIA_EN_ANTENNA_UNKNOWN = 0,
   DIA_EN_ANTENNA_1,
   DIA_EN_ANTENNA_2,
   DIA_EN_ANTENNA_COUNT
};

class dia_IOCtrlTunerAMFM_Antenna_PowerSupply
   : public dia_IOCtrlSignal,
     public dia_ITunerMasterControlListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_IOCtrlTunerAMFM_Antenna_PowerSupply);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_IOCtrlTunerAMFM_Antenna_PowerSupply);

public:
   //! class constructor
   dia_IOCtrlTunerAMFM_Antenna_PowerSupply ( dia_eAntennaNumber antennaNum );
   //! class destructor
   virtual ~dia_IOCtrlTunerAMFM_Antenna_PowerSupply ( void );

   //! start processing of the received request
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //! timeout occured during processing of the diagnosis request
   virtual void handleTimeout ( tVoid );

   //! result on the tunerAMFM_TunerPowerSupply_Set call.
   virtual void vOnTunerAMFMPowerSupply_Set ( dia_eTunerMasterControlPowerSupply powerSupply );

protected:
   //!
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   //! Antenna number
   dia_eAntennaNumber mAntennaNum;
};

#endif /* DIA_IOCTRLTUNERAMFM_ANTENNA_POWERSUPPLY_H_ */
