/*
 * dia_IOCtrlTunerAMFM_Antenna_PowerSupply.cpp
 *
 *  Created on: 15.10.2012
 *      Author: shw2abt
 */
// TTFis:> DIA_REQ UDS 06 2F 61 04 03 00

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "../../../depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#include "dia_IOCtrlTunerAMFM_Antenna_PowerSupply.h"

//-----------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_Antenna_PowerSupply::dia_IOCtrlTunerAMFM_Antenna_PowerSupply(dia_eAntennaNumber antennaNum ) :
      dia_IOCtrlSignal(
          (DIA_EN_ANTENNA_1==antennaNum) ? DIA_C_U16_DID_RBCM_TUNER_AMFM_1_POWER_SUPPLY      : ((DIA_EN_ANTENNA_2==antennaNum) ? DIA_C_U16_DID_RBCM_TUNER_AMFM_2_POWER_SUPPLY       : 0xFFFF /*unknown*/),
          (DIA_EN_ANTENNA_1==antennaNum) ? DIA_EN_IOCTRL_SIGTYPE_TUNERAMFM_ANT1_POWER_SUPPLY : ((DIA_EN_ANTENNA_2==antennaNum) ? DIA_EN_IOCTRL_SIGTYPE_TUNERAMFM_ANT2_POWER_SUPPLY  : DIA_EN_IOCTRL_SIGTYPE_UNKNOWN),
          1 /* Payload */
      ),
      mAntennaNum(antennaNum)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::dia_IOCtrlTunerAMFM_Antenna_PowerSupply");
}

//-----------------------------------------------------------------------------

dia_IOCtrlTunerAMFM_Antenna_PowerSupply::~dia_IOCtrlTunerAMFM_Antenna_PowerSupply ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlTunerAMFM_Antenna_PowerSupply::~dia_IOCtrlTunerAMFM_Antenna_PowerSupply !!!");
      NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest");
   tBool errorDetected = TRUE;

   dia_eTunerMasterControlPowerSupply powerSupply = DIA_EN_TUNERMASTERCONTROL_POWER_UNKNOWN;

   for(tU8 i=0; i<ctrlValue->size(); i++)
   {
      DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest input[%d] (0x%02x)",i,ctrlValue->at(i));
   }

   if ((DIA_EN_ANTENNA_UNKNOWN==mAntennaNum) || (mAntennaNum>=DIA_EN_ANTENNA_COUNT))
   {
      DIA_TR_ERR("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest: unknown antenna %d.", mAntennaNum);
      return DIA_FAILED;
   }

   switch (ctrlValue->at(0))
   {
      case 0x00:
         powerSupply = DIA_EN_TUNERMASTERCONTROL_POWER_PASSIV;
         DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest POWER_PASSIV. (0x%02x)",ctrlValue->at(0));
      break;

      case 0x01:
         powerSupply = DIA_EN_TUNERMASTERCONTROL_POWER_PHANTOM;
         DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest POWER_PHANTOM. (0x%02x)",ctrlValue->at(0));
      break;

      case 0x02:
         powerSupply = DIA_EN_TUNERMASTERCONTROL_POWER_EXTERNAL_PLUG;
         DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest POWER_EXTERNAL_PLUG. (0x%02x)",ctrlValue->at(0));
      break;

      default:
         DIA_TR_ERR("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest UNKNOWN POWER SUPPLY TYPE!");
      break;
   } //lint !e788: not all items intentionally used within defaulted switch

   if (powerSupply != DIA_EN_TUNERMASTERCONTROL_POWER_UNKNOWN)
   {
      dia_ITunerMasterControl* pInterface = 0;
      if (querySysAdapterInterface<dia_ITunerMasterControl>(&pInterface) == DIA_SUCCESS)
      {
         if (pInterface)
         {
            (void) setSysAdapterListener<dia_ITunerMasterControlListener>(this);

            tDiaResult result = DIA_FAILED;

            if (DIA_EN_ANTENNA_1==mAntennaNum)
            {
               DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest: DIA_EN_ANTENNA_1.");
               result = pInterface->tunerAMFM_TunerPowerSupply_Set(powerSupply);
            }
            else if (DIA_EN_ANTENNA_2==mAntennaNum)
            {
               DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest: DIA_EN_ANTENNA_2.");
               result = pInterface->tunerAMFM_TunerAntenna2PowerSupply_Set(powerSupply);
            }
            else
            {
               DIA_TR_ERR("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest: unknown antenna.");
            }

            if (DIA_SUCCESS==result)
            {
               DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest: PowerSupply_Set SUCCESS.");
               errorDetected = FALSE;
            }
            else
            {
               DIA_TR_ERR("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleRequest: PowerSupply_Set FAILED.");
            }
         }
      }
   }

   if (errorDetected)
   {
      (void) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
      DIA_TR_ERR("dia_IOCtrlTunerAMFM_Antenna_PowerSupply --- SEND TO TUNER MASTER CONTROL FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;

}

//----------------------------------------------------------------------------------------

void
dia_IOCtrlTunerAMFM_Antenna_PowerSupply::vOnTunerAMFMPowerSupply_Set(dia_eTunerMasterControlPowerSupply powerSupply)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::vOnTunerAMFMPowerSupply_Set");

   if (powerSupply != DIA_EN_TUNERMASTERCONTROL_POWER_UNKNOWN && powerSupply < DIA_EN_TUNERMASTERCONTROL_POWER_COUNT)
   {
      (void) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
      mIsResultReady = TRUE;
      DIA_TR_INF("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::vOnTunerAMFMPowerSupply_Set SUCCESS.");
   }
   else
   {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("DIA_IOCTRLTUNERAMFM...POWERSUPPLY::vOnTunerAMFMPowerSupply_Set NEGATIVE RESULT FROM SA!!!");
   }
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//----------------------------------------------------------------------------------------

void
dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleTimeout(void)
{
   dia_tclFnctTrace trc("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::handleTimeout");
   (void) unsetSysAdapterListener<dia_ITunerMasterControlListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlTunerAMFM_Antenna_PowerSupply::vOnTerminate(dia_eIOCtrlStatus /*status*/)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlTunerAMFM_Antenna_PowerSupply::vOnTerminate()");

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return DIA_E_NOERROR;
}
