#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlSystemHmiOn.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//-----------------------------------------------------------------------------
tBool
dia_IOCtrlSystemHmiOn::mIOCtrlStatus = FALSE;

tBool
dia_IOCtrlSystemHmiOn::mIOCtrlValue = FALSE;

//-----------------------------------------------------------------------------

dia_IOCtrlSystemHmiOn::dia_IOCtrlSystemHmiOn ( tVoid )
	: dia_IOCtrlSignal (
	      DIA_C_U16_DID_RBCM_SYSTEM_HMI_ON,
	      DIA_EN_IOCTRL_SIGTYPE_SYSTEM_HMI_ON,
	      DIA_EN_IOCTRL_CTRLMODE_ECU
	  )
{}

//-----------------------------------------------------------------------------

dia_IOCtrlSystemHmiOn::~dia_IOCtrlSystemHmiOn ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlSystemHmiOn::~dia_IOCtrlSystemHmiOn !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

   dia_IOCtrlSystemHmiOn::mIOCtrlStatus = FALSE;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSystemHmiOn::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSystemHmiOn::handleRequest()");
    
   tBool errorDetected = TRUE;

   dia_ISpm* pInterface = 0;
   if ( querySysAdapterInterface<dia_ISpm>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         mIOCtrlValue = ( ctrlValue->at(0) != 0 ) ? TRUE : FALSE;

         (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
         if ( pInterface->setSubState(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_ACTIVITY,mIOCtrlValue) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
      DIA_TR_ERR(" ---  SEND TO SPM SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlSystemHmiOn::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlSystemHmiOn::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_ISpm* pInterface = 0;
      if ( querySysAdapterInterface<dia_ISpm>(&pInterface) == DIA_SUCCESS )
      {
         if ( pInterface )
         {
            (tVoid) setSysAdapterListener<dia_ISpmListener>(this);
            if ( pInterface->setSubState(DIA_EN_SPM_SUBSTATE_DIAGNOSIS_ACTIVITY,FALSE) != DIA_SUCCESS )
            {
               DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SUBSTATE !!!");
            }
         }
      }
   }
    
   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlSystemHmiOn::vOnSubstateAck ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlSystemHmiOn::vOnSubstateAck");

   (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlSystemHmiOn::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlSystemHmiOn::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_ISpmListener>(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlSystemHmiOn::eSetStatus ( dia_eIOCtrlStatus newStatus )
{
   dia_IOCtrlSignal::eSetStatus(newStatus);
   dia_IOCtrlSystemHmiOn::mIOCtrlStatus = (newStatus == DIA_EN_IOCTRL_STATUS_ACTIVE) ? TRUE : FALSE;
}

//-----------------------------------------------------------------------------

tBool
dia_IOCtrlSystemHmiOn::getIOCtrlStatus ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlSystemHmiOn::getIOCtrlStatus");
   return mIOCtrlStatus;
}

//-----------------------------------------------------------------------------

tBool
dia_IOCtrlSystemHmiOn::getIOCtrlValue ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlSystemHmiOn::getIOCtrlValue");
   return mIOCtrlValue;
}

