/*
 * dia_IOCtrlRVCControlLine.cpp
 *
 *  Created on: 22.01.2013
 *      Author: shw2abt
 */
// TTFis: DIA_REQ UDS 06 2F 10 20 03 00/01

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlRVCControlLine.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//------------------------------------------------------------------------------

dia_IOCtrlRVCControlLine::dia_IOCtrlRVCControlLine ( tVoid )
   : dia_IOCtrlSignal (
         DIA_C_U16_DID_RBCM_IOCTRL_RVC_CONTROL_LINE,
         DIA_EN_IOCTRL_SIGTYPE_RVC_CONTROLLINE,
         1,
         DIA_EN_IOCTRL_CTRLMODE_TESTER
         )
{
}

//------------------------------------------------------------------------------

dia_IOCtrlRVCControlLine::~dia_IOCtrlRVCControlLine ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IRVCControlListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlRVCControlLine::~dia_IOCtrlRVCControlLine !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlRVCControlLine::handleFreeze ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlRVCControlLine::handleFreeze()");
   tDiaResult retCode = DIA_FAILED;

   dia_IRVCControl* pInterface = 0;
   if ( (querySysAdapterInterface<dia_IRVCControl>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      (tVoid) setSysAdapterListener<dia_IRVCControlListener>(this);
      retCode = pInterface->freezeRVCControl_ControlLine(DIA_EN_RVCCONTROL_CONTROLLINE_MODE_FREEZE);
      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_INF("dia_IOCtrlRVCControlLine - FAILED TO SET EMULATION MODE: KEYILLUMINATIONBRIGHTNESS !!!");
      }
   }

   if ( retCode == DIA_SUCCESS )
   {
      mIsResultReady = FALSE;
   }
   else
   {
      DIA_TR_INF("FAILED TO FREEZE KEY ILLUMINATION BRIGHTNESS !!!");
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlRVCControlLine::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlRVCControlLine::handleRequest()");
   tBool errorDetected = TRUE;

   dia_IRVCControl* pInterface = 0;
   if ( querySysAdapterInterface<dia_IRVCControl>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         (tVoid) setSysAdapterListener<dia_IRVCControlListener>(this);

         tU8 input_mode = ctrlValue->at(0);
         DIA_TR_INF("dia_IOCtrlRVCControlLine::handleRequest input_mode = 0x%02x",input_mode);
         dia_eRVCControl_ControlLine mode = DIA_EN_RVCCONTROL_CONTROLLINE_UNKNOWN;
         if(input_mode==0x00){
            mode = DIA_EN_RVCCONTROL_CONTROLLINE_OFF;
            DIA_TR_INF("dia_IOCtrlRVCControlLine::handleRequest mode = DIA_EN_RVCCONTROL_CONTROLLINE_OFF.");
         } else {
            mode = DIA_EN_RVCCONTROL_CONTROLLINE_ON;
            DIA_TR_INF("dia_IOCtrlRVCControlLine::handleRequest mode = DIA_EN_RVCCONTROL_CONTROLLINE_ON.");
         }

         if ( pInterface->setRVCControl_ControlLine(mode) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if (errorDetected) {
      (tVoid) unsetSysAdapterListener<dia_IRVCControlListener>(this);
      DIA_TR_ERR("dia_IOCtrlRVCControlLine --- SEND TO RVC CONTROL SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//==============================================================================

tDiaResult
dia_IOCtrlRVCControlLine::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlRVCControlLine::vOnTerminate()");
   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IRVCControl* pInterface = 0;
      if (querySysAdapterInterface<dia_IRVCControl>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (tVoid) setSysAdapterListener<dia_IRVCControlListener>(this);
            if (pInterface->freezeRVCControl_ControlLine ( DIA_EN_RVCCONTROL_CONTROLLINE_MODE_UNFREEZE ) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SELECT RVC CONTROL !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlRVCControlLine::vOnRVCControlLineFreezeMode (tDiaResult success, dia_eRVCControl_ControlLineFreeze freezeMode, tU8 /*enableMode*/)
{
   dia_tclFnctTrace trc("dia_IOCtrlRVCControlLine::vOnRVCControlLineFreezeMode");

   (tVoid) unsetSysAdapterListener<dia_IRVCControlListener>(this);

   if (success == DIA_SUCCESS) {
      DIA_TR_INF("dia_IOCtrlRVCControlLine::vOnRVCControlLineFreezeMode SUCCESSFUL !!!");

      if (freezeMode == DIA_EN_RVCCONTROL_CONTROLLINE_MODE_FREEZE) {
         DIA_TR_INF("dia_IOCtrlRVCControlLine::vOnRVCControlLineFreezeMode MODE_FREEZE !!!");
         (tVoid) dia_IOCtrlSignal::handleFreeze();
      } else if (freezeMode == DIA_EN_RVCCONTROL_CONTROLLINE_MODE_UNFREEZE) {
         DIA_TR_INF("dia_IOCtrlRVCControlLine::vOnRVCControlLineFreezeMode MODE_UNFREEZE !!!");
         (tVoid) dia_IOCtrlSignal::handleReturnControlToECU();
      } else {
         DIA_TR_ERR("dia_IOCtrlRVCControlLine::vOnRVCControlLineFreezeMode UNKNOWN freezeMode !!!");
      }
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlRVCControlLine::vOnRVCControlLineFreezeMode DIA_FAILED !!!");
   }

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlRVCControlLine::vOnRVC_ControlLine ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlRVCControlLine::vOnRVC_ControlLine");

   (tVoid) unsetSysAdapterListener<dia_IRVCControlListener>(this);
   mIsResultReady = TRUE;
   if (success == DIA_SUCCESS) {
      DIA_TR_INF("dia_IOCtrlRVCControlLine::vOnRVC_ControlLine SUCCESSFUL !!!");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT); // set error condition which is checked by the super class
      DIA_TR_ERR("dia_IOCtrlRVCControlLine::vOnRVC_ControlLine DIA_FAILED !!!");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlRVCControlLine::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlRVCControlLine::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IRVCControlListener>(this);
}


