/****************************************************************************************
 * dia_IOCtrlInputHdlPressedKey.h
 *
 *  Created on: 18.02.2014
 *      Author: wgl2hi
 *
 ---------------------------------------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 1.12.15         | ata7kor          | Added a new code to resolve ticket AIVI-15132
 *-------------------------------------------------------------------------------------
 
 *****************************************************************************************/

#ifndef __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_H__
#define __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_H__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INPUTHANDLING__
#include "common/interfaces/dia_IInputHandlingListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlInputHdlPressedKey
	: public dia_IOCtrlSignal,
	  public dia_IInputHandlingListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlInputHdlPressedKey ( void );
   //! class destructor
   virtual ~dia_IOCtrlInputHdlPressedKey ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );   
   //! 
   virtual void vOnSetKey ( const tDiaResult eDiaResult );

protected:
   //! 
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
   //! 
   tDiaResult triggerKey ( dia_eInputHandlingKeyInfo eKeyInfo ) const;
   //!
   tBool bPressDone;
   //!
   tU16 u16KeyCode;

   dia_eVdInuptHandlingKeyCode KeyID;

   dia_eVdInuptHandlingKeyCode getInputHandlingKeyCode ( tU16 u16KeyCode );
};

#endif // __INCLUDED_DIA_IOCTRL_INPUT_HDL_PRESSED_KEY_H__
