/**
 * \file    dia_IOCtrlHmiRemoteControl.h
 *
 * \brief   IOControl used to activate/deactivate remote control mode of the system
 *
 * \author  gib2hi
 * \date    2012/09/07
 */

#ifndef __INCLUDED_DIA_IOCTRL_SYSTEM_REMOTE_CONTROL__
#define __INCLUDED_DIA_IOCTRL_SYSTEM_REMOTE_CONTROL__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include <common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REMOTECONTROL_LISTENER__
#include <common/interfaces/dia_IRemoteControlListener.h>
#endif

////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlHmiRemoteControl
   : public dia_IOCtrlSignal,
     public dia_IRemoteControlListener
{
public:
   //! class constructor
   dia_IOCtrlHmiRemoteControl ( void );
   //! class destructor
   virtual ~dia_IOCtrlHmiRemoteControl ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //!
   virtual void handleTimeout ( void );

   //! remote control mode has been changed to the given mode
   virtual void vOnRemoteControlModeChanged ( dia_eRemoteCtrlMode newMode, dia_eRemoteCtrlMode prevMode );

protected:
   //! terminate remote control mode
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );
};

#endif /* __INCLUDED_DIA_IOCTRL_SYSTEM_REMOTE_CONTROL__ */

