
#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_REMOTECONTROL__
#include "common/framework/application/dia_RemoteControl.h"
#endif

#include "common/services/uds/production/dia_IOCtrlHmiRemoteControl.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//------------------------------------------------------------------------------

dia_IOCtrlHmiRemoteControl::dia_IOCtrlHmiRemoteControl ( tVoid )
   : dia_IOCtrlSignal(
         DIA_C_U16_DID_RBCM_SYSTEM_REMOTE_CONTROL,
         DIA_EN_IOCTRL_SIGTYPE_SYSTEM_REMOTE_CONTROL
     )
{}

//------------------------------------------------------------------------------

dia_IOCtrlHmiRemoteControl::~dia_IOCtrlHmiRemoteControl ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IRemoteControlListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlHmiRemoteControl::~dia_IOCtrlHmiRemoteControl !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlHmiRemoteControl::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHmiRemoteControl::handleRequest()");

   tBool errorDetected = TRUE;

   mIsResultReady = FALSE;

   if ( ctrlValue && ctrlValue->size() )
   {
      DIA_TR_INF(" ---  REMOTE CONTROL --- 0 !!!!");
      dia_IRemoteControl* pInterface = 0;
      tDiaResult queryRes;

      if ( ((queryRes = querySysAdapterInterface<dia_IRemoteControl>(&pInterface)) == DIA_SUCCESS) && pInterface )
      {
         DIA_TR_INF(" ---  REMOTE CONTROL --- 1 !!!!");
         (tVoid) setSysAdapterListener<dia_IRemoteControlListener>(this);

         dia_eRemoteCtrlMode mode = ( (*ctrlValue)[0] == 0x01 )
               ? DIA_EN_REMOTE_CONTROL_MODE_ACTIVE
               : DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE;

         DIA_TR_INF(" ---  REMOTE CONTROL --- 2 !!!! (mode=%d)", (*ctrlValue)[0] );

         if ( pInterface->getRemoteControlMode() == mode )
         {
            DIA_TR_INF(" ---  REMOTE CONTROL --- 3 !!!! pInterface->getRemoteControlMode() == mode");
            // requested remote control mode is already active
            errorDetected  = FALSE;
            mIsResultReady = TRUE;
         }
         else if ( pInterface->setRemoteControlMode(mode) == DIA_SUCCESS )
         {
            DIA_TR_INF(" ---  REMOTE CONTROL --- 4 !!!! pInterface->setRemoteControlMode(mode) == DIA_SUCCESS");
            errorDetected = FALSE;
         }
         else
         {
            DIA_TR_INF(" ---  REMOTE CONTROL --- 5 !!!!");
         }
      }
      else
      {
         DIA_TR_INF("querySysAdapterInterface FAILED! queryRes=0x%08X (decimal %u), pInterface=0x%p", queryRes, queryRes, pInterface);
      }
   }

   DIA_TR_INF(" ---  REMOTE CONTROL --- 6 !!!!");

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IRemoteControlListener>(this);
      DIA_TR_ERR(" ---  SEND TO REMOTE CONTROL FAILED!!!!");
      return DIA_FAILED;
   }

   if ( mIsResultReady )
   {
      (tVoid) unsetSysAdapterListener<dia_IRemoteControlListener>(this);
      DIA_TR_INF(" ---  SETTING REMOTE CONTROL MODE SUCCEEDED !!!!");
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlHmiRemoteControl::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlHmiRemoteControl::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IRemoteControl* pInterface = 0;
      if ( (querySysAdapterInterface<dia_IRemoteControl>(&pInterface) == DIA_SUCCESS) && pInterface )
      {
         (tVoid) setSysAdapterListener<dia_IRemoteControlListener>(this);
         if ( pInterface->setRemoteControlMode(DIA_EN_REMOTE_CONTROL_MODE_NOT_ACTIVE) != DIA_SUCCESS )
         {
            DIA_TR_INF("FAILED TO DEACTIVATE REMOTE CONTROL !!!");
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlHmiRemoteControl::vOnRemoteControlModeChanged ( dia_eRemoteCtrlMode /*newMode*/, dia_eRemoteCtrlMode /*prevMode*/ )
{
   dia_tclFnctTrace trc("dia_IOCtrlHmiRemoteControl::vOnRemoteControlModeChanged");

   (tVoid) unsetSysAdapterListener<dia_IRemoteControlListener>(this);
   mIsResultReady = TRUE;

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlHmiRemoteControl::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlHmiRemoteControl::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IRemoteControlListener>(this);
   
   getInstanceOfRemoteControl()->handleTimeout();
}

