/*
 * dia_IOCtrlHMILanguage.h
 *
 *  Created on: 21.02.2013
 *      Author: shw2abt
 */

#ifndef __INCLUDED_DIA_IOCTRL_HMI_LANGUAGE__
#define __INCLUDED_DIA_IOCTRL_HMI_LANGUAGE__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_HMILANGUAGE_LISTENER__
#include "common/interfaces/dia_IHMILanguageListener.h"
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlHMILanguage
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia_IHMILanguageListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlHMILanguage(tVoid);
   //! class destructor
   virtual ~dia_IOCtrlHMILanguage(tVoid);
   //! handle freeze request
//   virtual tDiaResult handleFreeze ( tVoid );

   virtual tDiaResult handleRequest(tU8 timerValue, std::vector<tU8>* ctrlValue);
   //!
   virtual tVoid handleTimeout(tVoid);

   //! result of the setHMILanguage operations
   virtual tVoid vOnSetHMILanguage(tDiaResult result);
   //! result on read the current HMI Language
   virtual tVoid vOnGetHMILanguage ( dia_eCMLanguage language );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate(dia_eIOCtrlStatus status);
   //! send set new HMI language
//   virtual tDiaResult setHMILanguage ( dia_eCMLanguage language );
   //! frozen value used to restore language in case of return control to ECU
   dia_eCMLanguage mLanguageBeforeFreeze;
};

#endif /* __INCLUDED_DIA_IOCTRL_HMI_LANGUAGE__ */
