/*
 * dia_IOCtrlGNSSPositioningSystem.cpp
 *
 *  Created on: 29.08.2012
 *      Author:
 */
// DIA_REQ UDS 06 2F 63 05 zz

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlGNSSPositioningSystem.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#define CTRL_VALUE_SIZE 1
//------------------------------------------------------------------------------

dia_IOCtrlGNSSPositioningSystem::dia_IOCtrlGNSSPositioningSystem ( tVoid )
	: dia_IOCtrlSignal (
		  DIA_C_U16_DID_SENSOR_GNSS_POS_SYSTEM,
	      DIA_EN_IOCTRL_SIGTYPE_GNSS_SYSTEM,
	      CTRL_VALUE_SIZE,
		  DIA_EN_IOCTRL_CTRLMODE_ECU
	  )/*
	  actualState(0xff)*/
{}

//------------------------------------------------------------------------------

dia_IOCtrlGNSSPositioningSystem::~dia_IOCtrlGNSSPositioningSystem ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlGNSSPositioningSystem::~dia_IOCtrlGNSSPositioningSystem !!!");
       DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlGNSSPositioningSystem::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlGNSSPositioningSystem::handleRequest()");
    
   tBool errorDetected = TRUE;

   dia_IGNSS* pInterface = 0;
   if ( querySysAdapterInterface<dia_IGNSS>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         tU8 u8GNSSSystem = ctrlValue->at(0);
         (tVoid) setSysAdapterListener<dia_IGNSSListener>(this);
         //if ( pInterface->setGNSSSystem(u8GNSSSystem) == DIA_SUCCESS )
		 if ( pInterface->setDiagGNSSSystem(u8GNSSSystem) == DIA_SUCCESS )
         {
            errorDetected = FALSE;
         }
      }
   }

   if ( errorDetected )
   {
      (tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);
      DIA_TR_ERR(" ---  SEND TO SENSOR SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlGNSSPositioningSystem::vOnTerminate ( dia_eIOCtrlStatus /*status*/ )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlGNSSPositioningSystem::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

/*   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }
   }
   // this ioctrl is no longer active
   eSetStatus(status);*/

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlGNSSPositioningSystem::vOnGNSSSatSystem ( tU8 /*u8Mode*/)
{
   dia_tclFnctTrace trc("dia_IOCtrlGNSSPositioningSystem::vOnGNSSSatSystem");

   (tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);
   //actualState = u8Mode;

   (tVoid) dia_IOCtrlSignal::handleFreeze();
   mIsResultReady = TRUE;
   eSetStatus (DIA_EN_IOCTRL_STATUS_ACTIVE);
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlGNSSPositioningSystem::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlGNSSPositioningSystem::handleTimeout");
   (tVoid) unsetSysAdapterListener<dia_IGNSSListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlGNSSPositioningSystem::vSetGnssMode ( dia_eGNSSMode mode )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlGNSSPositioningSystem::vSetGnssMode()");

   tDiaResult retCode = DIA_E_NOERROR;

      dia_IGNSS* pInterface = 0;
      if ( querySysAdapterInterface<dia_IGNSS>(&pInterface) == DIA_SUCCESS )
      {
         if ( pInterface )
         {
            (tVoid) setSysAdapterListener<dia_IGNSSListener>(this);
            retCode = pInterface->setGNSSSystem (mode);
            if ( retCode != DIA_SUCCESS )
            {
               DIA_TR_INF("FAILED TO SET THE GNSS MODE!!!");
            }
         }
      }

   return retCode;
}

//------------------------------------------------------------------------------
tDiaResult
dia_IOCtrlGNSSPositioningSystem::handleFreeze ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlGNSSPositioningSystem::handleFreeze()");
   tDiaResult retCode = DIA_FAILED;

   dia_IGNSS* pGNSS = 0;
   if ( querySysAdapterInterface<dia_IGNSS>(&pGNSS) == DIA_SUCCESS )
   {
      if ( pGNSS )
      {
         (tVoid) setSysAdapterListener<dia_IGNSSListener>(this);
         if ( pGNSS->getDiagGNSSSystem() == DIA_SUCCESS )
         {
            retCode = DIA_SUCCESS;
            mIsResultReady = FALSE;
         }
         else
         {
            setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
         }
      }
   }
   return retCode;
}
