/*
 * dia_IOCtrlFanSpeed.cpp
 *
 *  Created on: 08.06.2016
 *      Author: dvd5kor
 */
// TTFis: DIA_REQ UDS 06 2F ...

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef DIA_IOCTRL_FANSPEED_H_
#include "common/services/uds/production/dia_IOCtrlFanSpeed.h"
#endif

#ifndef __INCLUDED_DIA_SRVHANDLER_GENERIC_IOCTRL_BY_IDENTIFIER__
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"
#endif

#define PWM_VALUE_MAX 100
//------------------------------------------------------------------------------

dia_IOCtrlFanSpeed::dia_IOCtrlFanSpeed(void) :
   dia_IOCtrlSignal(
	     "dia_IOCtrlFanSpeed",
         DIA_C_U16_DID_RBCM_FAN_SPEED,
         1 /* Payload Length */
   )
{}

//------------------------------------------------------------------------------

dia_IOCtrlFanSpeed::~dia_IOCtrlFanSpeed(void)
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IHeatControlListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlFanSpeed::~dia_IOCtrlFanSpeed !!!");
      DIA_ASSERT_ALWAYS();
   }
_BP_CATCH_END}

 //------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlFanSpeed::handleRequest(tU8 /*timerValue*/, std::vector<tU8>* ctrlValue)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlFanSpeed::handleRequest(tU8,vector<tU8>*)");
   tBool errorDetected = TRUE;
   DIA_TR_INF("dia_IOCtrlFanSpeed::handleRequest: start Handling.");
   dia_IHeatControl* pInterface = 0;
   if (querySysAdapterInterface<dia_IHeatControl>(&pInterface) == DIA_SUCCESS) {
      if (pInterface) {
         (void) setSysAdapterListener<dia_IHeatControlListener>(this);
         tU8 speedPWM = ctrlValue->at(0);   //lint !e864 evaluation order is fine.
         DIA_TR_INF("dia_IOCtrlFanSpeed::handleRequest set speed to 0x (%d) (0-100).", speedPWM);
         if(speedPWM<=PWM_VALUE_MAX){
            if (pInterface->setFanSpeed(DIA_EN_HEATCTRL_FANPWRSTATE_ON, (tU8)speedPWM, DIA_EN_FAN_CTRL_MODE_ON) == DIA_SUCCESS) {
               errorDetected = FALSE;
            }
         } else {
            DIA_TR_INF("dia_IOCtrlFanSpeed::handleRequest speed (%d) is too high!", speedPWM);
         }
      }
   }

   if (errorDetected) {
      (void) unsetSysAdapterListener<dia_IHeatControlListener>(this);
      DIA_TR_ERR("dia_IOCtrlFanSpeed::handleRequest --- SEND TO HEATCONTROL SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlFanSpeed::vOnTerminate(dia_eIOCtrlStatus status)
{
   dia_tclFnctTrace oTrace("dia_IOCtrlFanSpeed::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if (eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE) {
      if (status == DIA_EN_IOCTRL_STATUS_INACTIVE) {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      dia_IHeatControl* pInterface = 0;
      if (querySysAdapterInterface<dia_IHeatControl>(&pInterface) == DIA_SUCCESS) {
         if (pInterface) {
            (void) setSysAdapterListener<dia_IHeatControlListener>(this);
            if (pInterface->setFanSpeed(DIA_EN_HEATCTRL_FANPWRSTATE_ON, 0, DIA_EN_FAN_CTRL_MODE_OFF) != DIA_SUCCESS) {
               DIA_TR_ERR("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET FAN SPEED !!!");
            }
         }
      }
   }

   // this ioctrl is no longer active
   eSetStatus(status);

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlFanSpeed::vOnFanSpeedSet ( tDiaResult success )
{
   dia_tclFnctTrace trc("dia_IOCtrlFanSpeed::vOnFanSpeedSet");
   
   (void) unsetSysAdapterListener<dia_IHeatControlListener>(this);
   mIsResultReady = TRUE;
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlFanSpeed::vOnFanSpeedSet SUCCESSFUL .");
   } else {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
      DIA_TR_ERR("dia_IOCtrlFanSpeed::vOnFanSpeedSet DIA_FAILED !");
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlFanSpeed::handleTimeout(void)
{
   dia_tclFnctTrace trc("dia_IOCtrlFanSpeed::handleTimeout");
   (void) unsetSysAdapterListener<dia_IHeatControlListener>(this);
}
