/*
* dia_IOCtrlDisplayTestPattern.cpp
*
*  Created on: 05.09.2012
*      Author: akn1kor
*
*      Date      | Author             | Modification
* 17.10.04  	 | bsu9kor			  | Code change to support 3 new screens AIVI-20477.
*/
// DIA_REQ UDS 06 2F 62 02 cc zz zz -> 2 bytes of PWM value

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

// #include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

#ifndef __INCLUDED_DIA_IOCTRL_MANAGER__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlManager.h"
#endif

#ifndef DIA_IOCTRL_DISPLAY_TEST_PATTERN_H_
#include "dia_IOCtrlDisplayTestPattern.h"
#endif

#define DIA_C_U8_MAX_NUMBER_OF_CMDS_TEST_PATTERNS  ((tU8)    9)
#define DIA_C_U8_NAC_TEST_SCREENS                  ((tU8) 0x5C) // not a real test pattern, will start the NAC test
#define DIA_C_U8_RGB_NOK						   ((tU8) 0x10)
#define DIA_C_U8_RGB_OK							   ((tU8) 0x11)
#define DIA_C_U8_RGB_REPDARK					   ((tU8) 0x12)

//------------------------------------------------------------------------------

dia_IOCtrlDisplayTestPattern::dia_IOCtrlDisplayTestPattern ( void )
: dia_IOCtrlSignal (
               DIA_C_U16_DID_RBCM_DISPLAY_TEST_PATTERN,
               DIA_EN_IOCTRL_SIGTYPE_DISPLAY_TEST,
               1,
               DIA_EN_IOCTRL_CTRLMODE_TESTER
               )
{}

//------------------------------------------------------------------------------

dia_IOCtrlDisplayTestPattern::~dia_IOCtrlDisplayTestPattern ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IDisplayTestListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlDisplayTestPattern::~dia_IOCtrlDisplayTestPattern !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestPattern::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTestPattern::handleRequest()");

   if ( DIA_SUCCESS != SetScreen( ctrlValue->at(0) ) )
   {
      (void) unsetSysAdapterListener<dia_IDisplayTestListener>(this);
      DIA_TR_ERR(" ---  SEND TO HMI FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestPattern::vOnTerminate ( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlDisplayTestPattern::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if ( status == DIA_EN_IOCTRL_STATUS_INACTIVE)
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }

      // Set to normal HMI screen
      if ( DIA_SUCCESS != SetScreen(0) )
      {
         DIA_TR_INF("FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY SET : TEST SCREEN !!!");
         retCode = DIA_FAILED;
      }
   }

   // this ioctrl is no longer active
   // eSetStatus(status); // Don't set the status, wait for the response from HMI

   return retCode;
}


//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTestPattern::vOnSetDisplayTestPatternDone (  tDiaResult res )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayTestPattern::vOnSetDisplayTestPatternDone");
   
   (void) unsetSysAdapterListener<dia_IDisplayTestListener>(this);
   mIsResultReady = TRUE;

   if(DIA_SUCCESS == res)
   {
      setErrorInfo(DIA_E_NOERROR);
   }
   else
   {
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   }
   
   dia_IOCtrlManager::vOnSignalUpdate(*this);
   
// #ifndef __DIA_UNIT_TESTING__
      // dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
// #endif
}

//-----------------------------------------------------------------------------

void
dia_IOCtrlDisplayTestPattern::handleTimeout ( void )
{
   dia_tclFnctTrace trc("dia_IOCtrlDisplayTestPattern::handleTimeout");
   (void) unsetSysAdapterListener<dia_IDisplayTestListener>(this);
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlDisplayTestPattern::SetScreen(tU8 u8Screen)
{
   static dia_eDisplayPatternID dispPatternMapping[DIA_C_U8_MAX_NUMBER_OF_CMDS_TEST_PATTERNS] = {
         DIA_EN_DISPLAY_PATTERN_NONE,
         DIA_EN_DISPLAY_PATTERN_WHITE,
         DIA_EN_DISPLAY_PATTERN_BLACK,
         DIA_EN_DISPLAY_PATTERN_RED,
         DIA_EN_DISPLAY_PATTERN_GREEN,
         DIA_EN_DISPLAY_PATTERN_BLUE,
         DIA_EN_DISPLAY_PATTERN_COLOURED,
         DIA_EN_DISPLAY_PATTERN_FLICKER_TEST,
         DIA_EN_DISPLAY_PATTERN_TEST_MARK
   };

   tDiaResult ret = DIA_FAILED;

   dia_IDisplayTest* pInterface = 0;
   if ( querySysAdapterInterface<dia_IDisplayTest>(&pInterface) == DIA_SUCCESS )
   {
      if ( pInterface )
      {
         dia_eDisplayPatternID patternID = DIA_EN_DISPLAY_PATTERN_UNKNOWN;
         if ( u8Screen < DIA_C_U8_MAX_NUMBER_OF_CMDS_TEST_PATTERNS )
         {
            patternID = dispPatternMapping[u8Screen];
         }
         else if ( u8Screen == DIA_C_U8_NAC_TEST_SCREENS )
         {
            patternID = DIA_EN_DISPLAY_PATTERN_TEF_SPECIAL1;
         }
         else if ( u8Screen == DIA_C_U8_RGB_NOK )
         {
        	 //DIA_TR_INF("SENDING REQ FOR RGB_NOK !!!");
        	 patternID = DIA_EN_DISPLAY_PATTERN_RGB_NOK;
         }
         else if ( u8Screen == DIA_C_U8_RGB_OK )
         {
        	 //DIA_TR_INF("SENDING REQ FOR RGB_OK !!!");
        	 patternID = DIA_EN_DISPLAY_PATTERN_RGB_OK;
         }
         else if ( u8Screen == DIA_C_U8_RGB_REPDARK )
         {
        	 //DIA_TR_INF("SENDING REQ FOR RGB_REPDARK !!!");
        	 patternID = DIA_EN_DISPLAY_PATTERN_RGB_REPDARK;
         }

         if ( patternID != DIA_EN_DISPLAY_PATTERN_UNKNOWN )
         {
            (void) setSysAdapterListener<dia_IDisplayTestListener>(this);
            ret = pInterface->setDisplayPatternID(patternID);
         }
      }
   }
   return ret;
}

//------------------------------------------------------------------------------

