/*
 * dia_IOCtrlCDResetLine.cpp
 *
 *  Created on: 28.01.2013
 *      Author: shw2abt
 */

//!!! No reference ServiceHandler; has no connection to the SAFeature framework

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG_PROJECT__
#include "project/framework/config/dia_defsProjectConfig.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#include "common/services/uds/production/dia_IOCtrlCDResetLine.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"

//------------------------------------------------------------------------------

dia_IOCtrlCDResetLine::dia_IOCtrlCDResetLine ( tVoid )
   : dia_IOCtrlSignal (
         DIA_C_U16_DID_RBCM_OPTICAL_DRIVE_RESET_LINE,
         DIA_EN_IOCTRL_SIGTYPE_CD_RESET_LINE,
         PAYLOAD_LEN  // payload
         //DIA_EN_IOCTRL_CTRLMODE_ECU
         // 4. legt Zeitueberwachung fest - Monitoring Mode
     ),
     mGpioStatusCDResetLine(0x00)
{
}

//------------------------------------------------------------------------------

dia_IOCtrlCDResetLine::~dia_IOCtrlCDResetLine ( tVoid )
{
//   _BP_TRY_BEGIN
//   {
////      (tVoid) unsetSysAdapterListener<dia_I...>(this);
//   }
//   _BP_CATCH_ALL
//   {
//       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlCDResetLine::~dia_IOCtrlCDResetLine !!!");
//       NORMAL_M_ASSERT_ALWAYS();
//   }
//   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCDResetLine::handleFreeze ( tVoid )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlCDResetLine::handleFreeze()");

   // retrieve size of property
   size_t length = 1;
   tDiaResult retCode = dia_getProperty(DIA_PROP_GPIO_CD_CDROM_RESET, &mGpioStatusCDResetLine,&length);

   if ( retCode == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlCDResetLine::handleFreeze - GPIO CD RESET LINE (FREEZE): 0x%02x", mGpioStatusCDResetLine);
   }
   else
   {
      DIA_TR_INF("dia_IOCtrlCDResetLine::handleFreeze - GPIO CD RESET LINE (FREEZE): UNKNOWN (FAILED TO READ STATE)");
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   }

   (tVoid) dia_IOCtrlSignal::handleFreeze();
   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCDResetLine::handleRequest ( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlCDResetLine::handleRequest(tU8,vector<tU8>*)");

   tDiaResult retCode = setGpioCDResetLine((tU8) ctrlValue->at(0));
   if ( retCode == DIA_SUCCESS )
   {
      DIA_TR_INF("dia_IOCtrlCDResetLine::handleRequest - GPIO CD RESET LINE: 0x%02x", mGpioStatusCDResetLine);
   }
   else
   {
      DIA_TR_INF("dia_IOCtrlCDResetLine::handleRequest - GPIO CD RESET LINE: UNKNOWN (FAILED TO SET STATE)");
      setErrorInfo(DIA_E_CONDITIONS_NOT_CORRECT);
   }

   // now initialize the counter for the timer
   vSetTimer(DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE);

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCDResetLine::vOnTerminate ( dia_eIOCtrlStatus /*status*/ )
{
   dia_tclFnctTrace oTrace("dia_IOCtrlCDResetLine::vOnTerminate()");

   tDiaResult retCode = DIA_E_NOERROR;

   if ( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      retCode = setGpioCDResetLine((tU8) mGpioStatusCDResetLine);
      if (retCode == DIA_SUCCESS) {
         DIA_TR_INF("dia_IOCtrlCDResetLine::vOnTerminate - GPIO CD RESET LINE (RETURN CONTROL): 0x%02x", mGpioStatusCDResetLine);
      } else {
         DIA_TR_ERR("dia_IOCtrlCDResetLine::vOnTerminate --- ERROR DETECTED (0x%x) !!!!" , retCode);
      }
   }

   mIsResultReady = TRUE;
   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlCDResetLine::vOnSetGPIOStatus ( tU8 /*status*/ ){
   dia_tclFnctTrace trc("dia_IOCtrlCDResetLine::vOnSetGPIOStatus");

   DIA_TR_INF("dia_IOCtrlCDResetLine::vOnSetGPIOStatus: Handle Result Message. ----------------------");

   mIsResultReady = TRUE;
//   not necessary in this special case
//   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate(this);
}

//-----------------------------------------------------------------------------

tVoid
dia_IOCtrlCDResetLine::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc("dia_IOCtrlCDResetLine::handleTimeout");
}

//------------------------------------------------------------------------------

tDiaResult
dia_IOCtrlCDResetLine::setGpioCDResetLine ( tU8 value ) const
{
   dia_tclFnctTrace oTrace("dia_IOCtrlMicrophonePowerSupply::setGpioCDResetLine(tU8)");

   tDiaResult retCode = DIA_FAILED;

   if ( (value == GPIOSTATUSLEVEL_OFF) || ( value == GPIOSTATUSLEVEL_ON) )
   {
      tU8 propData[PAYLOAD_LEN] = { value };
      retCode = dia_setProperty(DIA_PROP_GPIO_CD_CDROM_RESET, propData, PAYLOAD_LEN);
      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_ERR("dia_IOCtrlCDResetLine --- ERROR DETECTED (0x%x) !!!!" , retCode);
      }
   }
   else
   {
      DIA_TR_ERR("dia_IOCtrlCDResetLine::handleRequest WRONG LEVEL 0x%02x (only 1 and 0 are allowed) !", value );
   }

   return retCode;
}
