/*
 * dia_IOCtrlCDModeControl.cpp
 *
 *  Created on: 04.02.2014
 *      Author: shw2abt
 */
//TTFis:> DIA_REQ UDS 07 2F 64 18 03 0x
//                                  (01) -> switch to CDDA
//                                  (02) -> switch to CDROM

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "common/services/uds/production/dia_IOCtrlCDModeControl.h"
#include "common/services/uds/generic/dia_SrvHandlerGenericIOCtrlByIdentifier.h"


//------------------------------------------------------------------------------

dia_IOCtrlCDModeControl::dia_IOCtrlCDModeControl( tVoid )
   : dia_IOCtrlSignalRestrictedToRemoteControl (
         DIA_C_U16_DID_RBCM_CD_MODE_CONTROL,
         DIA_EN_IOCTRL_SIGTYPE_CD_MODE_CONTROL,
         1 // Payload lenght
         //DIA_EN_IOCTRL_CTRLMODE_ECU
         // 4. legt Zeitueberwachung fest - Monitoring Mode
     )
{
   m_pInterfaceMMgr = 0;
   m_pInterfaceDVM  = 0;
   m_Switch2        = 0;
}

//------------------------------------------------------------------------------

dia_IOCtrlCDModeControl::~dia_IOCtrlCDModeControl ( tVoid )
{
   _BP_TRY_BEGIN
   {
      (tVoid)unsetSysAdapterListener<dia_IVDMMGRListener>(this);
      (tVoid)unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
   }
   _BP_CATCH_ALL
   {
       DIA_TR_ERR("EXCEPTION CAUGHT: dia_IOCtrlCDModeControl::~dia_IOCtrlCDModeControl !!!");
       NORMAL_M_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

   m_pInterfaceMMgr = 0;
   m_pInterfaceDVM  = 0;
}

//------------------------------------------------------------------------------

tDiaResult dia_IOCtrlCDModeControl::handleRequest( tU8 /*timerValue*/, std::vector<tU8>* ctrlValue )
{
   dia_tclFnctTrace oTrace( "dia_IOCtrlCDModeControl::handleRequest(tU8,vector<tU8>*)" );

   tBool errorDetected = FALSE;

   DIA_TR_INF( "dia_IOCtrlCDModeControl::handleRequest: start Handling." );

   m_pInterfaceMMgr = 0;
   m_pInterfaceDVM  = 0;
   if(   querySysAdapterInterface<dia_IVDMMGR>(&m_pInterfaceMMgr)   == DIA_SUCCESS
      && querySysAdapterInterface<dia_IDeviceMGR>(&m_pInterfaceDVM) == DIA_SUCCESS
     )
   {
      if( m_pInterfaceMMgr && m_pInterfaceDVM )
      {
         m_Switch2 = ctrlValue->at( 0 );

         (tVoid)setSysAdapterListener<dia_IVDMMGRListener>(this);
         (tVoid)setSysAdapterListener<dia_IDeviceMGRListener>(this);

         switch( m_Switch2 )
         {
            case SWITCH2CDDA:                                                    // switch to CD DA
               if ( m_pInterfaceDVM->selectCDMode( DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_CDDA ) != DIA_SUCCESS )
               {
                  errorDetected = TRUE;
                  DIA_TR_INF( "dia_IOCtrlCDModeControl::handleRequest: m_pInterfaceDVM failed" );
               }
               // if VD DVM part was OK untill here wait for VD DVM Methodresult
               // and start VD MediaManager part when VD DeviceManager part is completely OK
               break;
            case SWITCH2CDROM:                                                   // switch to CD ROM
               if ( m_pInterfaceMMgr->selectCDMode( DIA_EN_MMGR_CD_MODE_SWITCH_TO_CDROM ) != DIA_SUCCESS )
               {
                  errorDetected = TRUE;
                  DIA_TR_INF( "dia_IOCtrlCDModeControl::handleRequest: m_pInterfaceMMgr failed" );
               }
               // if VD MMgr part was OK untill here wait for VD MMgr Methodresult
               // and start VD DeviceManager part when VD MediaManager part is completely OK
               break;
            default:                                                       // unexpected -> error
                  errorDetected = TRUE;
                  DIA_TR_INF( "dia_IOCtrlCDModeControl::handleRequest: unexpected parameter value: %d", m_Switch2 );
               break;
         }
      }
   }
   else  // -> pointer check failed
   {
      errorDetected = TRUE;
      DIA_TR_INF("querySysAdapterInterface<dia_IVDMMGR>(&m_pInterfaceMMgr) OR querySysAdapterInterface<dia_IDeviceMGR>(&m_pInterfaceDVM) failed");
      DIA_TR_INF("dia_IOCtrlCDModeControl::handleRequest: m_pInterfaceMMgr = %p", m_pInterfaceMMgr );
      DIA_TR_INF("dia_IOCtrlCDModeControl::handleRequest: m_pInterfaceDVM  = %p", m_pInterfaceDVM );
   }

   if( errorDetected )
   {
      (tVoid)unsetSysAdapterListener<dia_IVDMMGRListener>(this);
      (tVoid)unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
      DIA_TR_ERR("dia_IOCtrlCDModeControl ---  SEND TO VDMMGR or to DeviceMgr SERVER FAILED!!!!");
      return DIA_FAILED;
   }

   // now initialize the counter for the timer
   vSetTimer( DIA_C_U8_UDS_IOCTRL_TIMER_VALUE_INFINITE );

   mIsResultReady = FALSE;

   // NO_ERROR allows the service handler to return immediately
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult dia_IOCtrlCDModeControl::vOnTerminate( dia_eIOCtrlStatus status )
{
   dia_tclFnctTrace oTrace( "dia_IOCtrlCDModeControl::vOnTerminate()" );

   tDiaResult retCode = DIA_E_NOERROR;

   if( eGetStatus() == DIA_EN_IOCTRL_STATUS_ACTIVE )
   {
      if( status == DIA_EN_IOCTRL_STATUS_INACTIVE )
      {
         // we have to wait for the response
         mIsResultReady = FALSE;
      }
/*      m_pInterfaceMMgr = 0;
      m_pInterfaceDVM  = 0;
      if(   ( querySysAdapterInterface<dia_IVDMMGR>(&m_pInterfaceMMgr) == DIA_SUCCESS )
         && ( querySysAdapterInterface<dia_IDeviceMGR>(&)              == DIA_SUCCESS )
      {
         if( m_pInterfaceMMgr && m_pInterfaceDVM )
         {
            (tVoid) setSysAdapterListener<dia_IVDMMGR>(this);
            (tVoid) setSysAdapterListener<dia_IDeviceMGR>(this);
            if ( m_pInterfaceMMgr->selectCDMode( DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_UNKNOWN ) != DIA_SUCCESS )
            {
               DIA_TR_INF( "dia_IOCtrlCDModeControl::vOnTerminate: FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY CD_MODE_CHANGE (m_pInterfaceMMgr->selectCDMode()) !!!" );
            }
            if ( m_pInterfaceDVM->selectCDMode( DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_UNKNOWN ) != DIA_SUCCESS )
            {
               DIA_TR_INF( "dia_IOCtrlCDModeControl::vOnTerminate: FAILED TO DEACTIVATE DIAGNOSIS ACTIVITY CD_MODE_CHANGE (m_pInterfaceDVM->selectCDMode()) !!!" );
            }
         }
      }*/
   }

   // this ioctrl is no longer active
   eSetStatus( status );

   return retCode;
}

//-----------------------------------------------------------------------------

tVoid dia_IOCtrlCDModeControl::vOnCDModeChangeResultMMgr( tDiaResult success )
{
   dia_tclFnctTrace trc( "dia_IOCtrlCDModeControl::vOnCDModeChangeResultMMgr" );

   tBool errorDetected = FALSE;

   (tVoid)unsetSysAdapterListener<dia_IVDMMGRListener>( this );
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF( "dia_IOCtrlCDModeControl::vOnCDModeChangeResultMMgr SUCCESSFUL !!!" );
      if( m_Switch2 == SWITCH2CDDA )
      {
         // If the CD mode changed to CD DA the VD MMgr part was the last part
         mIsResultReady = TRUE;
      }
      else  // switch to CD ROM
      {
         // the VD MMgr part is done now start the VD DVM part
         if( !m_pInterfaceDVM || (m_pInterfaceDVM->selectCDMode( DIA_EN_DEVMGR_CD_MODE_SWITCH_TO_CDROM ) != DIA_SUCCESS) )
         {
            errorDetected = TRUE;
            DIA_TR_INF( "dia_IOCtrlCDModeControl::vOnCDModeChangeResultMMgr: m_pInterfaceDVM failed" );
         }
      }
   }
   else
   {
      errorDetected = TRUE;
   }

   if( errorDetected  )
   {
      setErrorInfo( DIA_E_CONDITIONS_NOT_CORRECT );
      DIA_TR_ERR("dia_IOCtrlCDModeControl::vOnCDModeChangeResultMMgr DIA_FAILED !!!" );
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate( this );
}

//-----------------------------------------------------------------------------

tVoid dia_IOCtrlCDModeControl::vOnCDModeChangeResultDVM( tDiaResult success )
{
   dia_tclFnctTrace trc( "dia_IOCtrlCDModeControl::vOnCDModeChangeResultDVM" );

   tBool errorDetected = FALSE;

   (tVoid)unsetSysAdapterListener<dia_IDeviceMGRListener>( this );
   if( success == DIA_SUCCESS )
   {
      DIA_TR_INF( "dia_IOCtrlCDModeControl::vOnCDModeChangeResultDVM SUCCESSFUL !!!" );
      if( m_Switch2 == SWITCH2CDROM )
      {
         // If the CD mode changed to CD ROM the VD DVM part was the last part
         mIsResultReady = TRUE;
      }
      else  // switch to CD DA
      {
         // the VD MMgr part is done now start the VD DVM part
         if( !m_pInterfaceMMgr || (m_pInterfaceMMgr->selectCDMode( DIA_EN_MMGR_CD_MODE_SWITCH_TO_CDDA ) != DIA_SUCCESS) )
         {
            errorDetected = TRUE;
            DIA_TR_INF( "dia_IOCtrlCDModeControl::vOnCDModeChangeResultDVM: m_pInterfaceDVM failed" );
         }
      }
   }
   else
   {
      errorDetected = TRUE;
   }

   if( errorDetected  )
   {
      setErrorInfo( DIA_E_CONDITIONS_NOT_CORRECT );
      DIA_TR_ERR("dia_IOCtrlCDModeControl::vOnCDModeChangeResultDVM DIA_FAILED !!!" );
   }

   dia_SrvHandlerGenericIOCtrlByIdentifier::vOnSignalUpdate( this );
}

//-----------------------------------------------------------------------------

tVoid dia_IOCtrlCDModeControl::handleTimeout ( tVoid )
{
   dia_tclFnctTrace trc( "dia_IOCtrlCDModeControl::handleTimeout" );
   (tVoid)unsetSysAdapterListener<dia_IVDMMGRListener>(this);
   (tVoid)unsetSysAdapterListener<dia_IDeviceMGRListener>(this);
}

