/**
 * \file      dia_IOCtrlBluetoothMode.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      12.10.2012
 *
 * \copyright Robert Bosch Car Multimedia 2012
 *
 *
 * --------------------------------------------------------
 * Date 	       | Author	          | Modification
 * 13.06.14        | GPU2KOR          | Updated BT mode set.
 *************************************************************************/


#ifndef __INCLUDED_DIA_IOCTRL_BLUETOOTH_MODE__
#define __INCLUDED_DIA_IOCTRL_BLUETOOTH_MODE__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

// #ifndef __INCLUDED_DIA_BLUETOOTHMODEFSM__
// #include "common/framework/fsm/generated/dia_BluetoothModeFSM.h"
// #endif

// #ifndef __INCLUDED_DIA_INTERFACE_BLUETOOTH_LISTENER__
// #include "project/interfaces/dia_IBluetoothListener.h"
// #endif

//#define DIA_MCN_BT_MODECHANGE_TIMEOUT           15000

//-----------------------------------------------------------------------------

class dia_IOCtrlBluetoothMode
   : public dia_IOCtrlSignal //,
     // public dia_IBluetoothListenerImpl,
     // protected dia_BluetoothModeFSM::FsmBehaviour
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_IOCtrlBluetoothMode);

public:
   //! class constructor
   dia_IOCtrlBluetoothMode ( tVoid );
   //! class destructor
   virtual ~dia_IOCtrlBluetoothMode ( tVoid );

   // initial initialization of the FSM
   virtual tVoid vInit ( tVoid );

   //! perform the iocontrol adjustment
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! timeout has been elapsed
   virtual tVoid handleTimeout ( tVoid );

   //! return the maximum processing time for this request
//   virtual tU32  u32MaxPgTime ( tVoid ) const { return DIA_MCN_BT_MODECHANGE_TIMEOUT; }

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_IBluetoothListener methods
   //
   //-------------------------------------------------------------------------

   //! notification of the current BT mode
   // virtual tVoid vOnBTModeStatus ( dia_eBTMode mode );
   //! notification that the BT mode request was accepted by phone component
   // virtual tVoid vOnBTModeRequestACK ( tBool result );
   //! notification of BT action result
   // virtual tVoid vOnBTTestActionStatus ( dia_eBTAction action );
   //! notification that the BT action request was accepted by phone component
   // virtual tVoid vOnBTTestActionRequestACK ( tBool result );

protected:
   //! helper used to return control to ECU
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   //-------------------------------------------------------------------------
   //
   // Overloaded dia_BluetoothModeFSM::FsmBehaviour methods
   //
   //-------------------------------------------------------------------------

   //---- FSM actions------
   //! set requested mode to NORMAL
   // virtual void vSetRequestedModeNormal ( void* pArg );
   //! set requested mode to LOOPBACK
   // virtual void vSetRequestedModeProduction ( void* pArg );
   //! set requested mode to DUT (device under test)
   // virtual void vSetRequestedModeDUT ( void* pArg );
   //! send a request to switch the bluetooth module to normal mode
   // virtual void vSendNormalModeRequest ( void* pArg );
   //! send a request to switch the bluetooth module to production mode
   // virtual void vSendProductionModeRequest ( void* pArg );
   //! send a request to switch the bluetooth module to DUT mode
   // virtual void vSendDUTModeRequest ( void* pArg );
   //! register for FID FID_TEL_G_BT_TEST_MODE
   // virtual void vSendUpRegTestMode ( void* pArg );
   //! unregister for FID FID_TEL_G_BT_TEST_MODE
   // virtual void vSendRelRegTestMode ( void* pArg );
   //! send a request to switch the I2S test tone on
   // virtual void vSendStartTestToneRequest ( void* pArg );
   //! send a request to switch the I2S test tone off
   // virtual void vSendStopTestToneRequest ( void* pArg );
   //! register for FID_TEL_G_BTM_TEST_ACTION
   // virtual void vSendUpRegTestTone ( void* pArg );
   //! unregister for FID FID_TEL_G_BTM_TEST_ACTION
   // virtual void vSendRelRegTestTone ( void* pArg );
   //! send positive response to prod tester
   // virtual void vSendPositiveResponse ( void* pArg );
   //! send negative response prod tester
   // virtual void vSendNegativeResponse ( void* pArg );
  //! send request to start the local loopback
   // virtual void vSendStartLoopbackRequest ( void* pArg );
  //! send request to stop the local loopback
   // virtual void vSendStopLoopbackRequest ( void* pArg );

   //---- FSM guards------
   //! check if the test tone is currently active
   // virtual bool bIsI2STestToneActive ( void* pArg );
   //! check if loopback mode has to be set
   // virtual bool bIsProductionModeRequested ( void* pArg );
   //! check if the production mode of the BT module is already activated
   // virtual bool bIsProductionModeActivated ( void* pArg );
   //! check if normal mode has to be set
   // virtual bool bIsNormalModeRequested ( void* pArg );
   //! check if the production mode of the BT module is already activated
   // virtual bool bIsNormalModeActivated ( void* pArg );
   //! check if HCI mode has to be set
   // virtual bool bIsDUTModeRequested ( void* pArg );
   //! check if the DUT mode of the BT module is activated
   // virtual bool bIsDUTModeActivated ( void* pArg );
   //! check if the BT module has accepted the modechange request
   // virtual bool bIsModeReqAccepted ( void* pArg );
   //! check if the BT module has reached the requested mode
   // virtual bool bIsRequestedModeReached ( void* pArg );
   //! check if the BT module has accepted the test tone request
   // virtual bool bIsTestToneReqAccepted ( void* pArg );
   //! check if the BT module has executed the test tone request
   // virtual bool bIsTestToneReqExecuted ( void* pArg );
   //! local loopback test is running
   // virtual bool bIsLoopbackActive ( void* pArg );
   //! local loopback test request was executed
   // virtual bool bIsLoopbackReqExecuted ( void* pArg );

   //
   // helper methods
   //

   //! send the request for the given mode to the phone component
   // void vSendModeRequest ( dia_eBTMode mode );
   //! send the given test tone request to the phone component
   // void vSendTestActionRequest ( dia_eBTAction action );

// private:
    //! interface pointer used to interact with the BT module
    // dia_IBluetooth* mpBTInterface;

    //! currently activated test mode
    // static dia_eBTMode mCurrentMode;
    //! current state of the test tone = enabled/disabled
    // static tBool mIsI2STestToneActive;
    //! current state of the local loopback = enabled/disabled
    // static tBool mIsLocalLoopbackActive;

    //! stores the requested BT mode
    // dia_eBTMode mRequestedMode;
    //! ACK for the requested BT mode
    // tBool mModeRequestACK;

    //! stores the requested test tone action
    // dia_eBTAction mRequestedAction;
    //! ACK for the requested BT mode
    // tBool mActionRequestACK;

    //! flag to indicate that we are registered to get mode status updates
    // tBool mIsRegisteredForModeStatus;
    //! Flag to indicate that we are registered to get test tone status updates
    // tBool mIsRegisteredForTestToneStatus;

    //! error code
    // tDiaResult mErrorCode;

//    //! store the result of send operation
//    tDiaResult mSendResult;

    //! pointer to the FSM
    // dia_BluetoothModeFSM::Fsm* mpBTModeFSM;

};


#endif /* __INCLUDED_DIA_IOCTRL_BLUETOOTH_MODE__ */

