/*
 * dia_IOCtrlAudioTestTone.h
 *
 *  Created on: 03.08.2012
 *      Author: shw2abt
 */
/*
 * The system shall implement a diagnostic service IOControl audioTesttone to provide the diagnostic tester the ability to enable/disable an audio test tone.
 * The system shall provide the tester the ability to set the frequency and volume of the test tone.
 */

#ifndef DIA_IOCTRLAUDIOTESTTONE_H_
#define DIA_IOCTRLAUDIOTESTTONE_H_

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignal.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_AUDIO_LISTENER__
#include "common/interfaces/dia_IAudioListener.h"
#endif

class dia_IOCtrlAudioTestTone
	: public dia_IOCtrlSignal,
	  public dia_IAudioListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlAudioTestTone ( void );
   //! class destructor
   virtual ~dia_IOCtrlAudioTestTone ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );

   //!
   virtual void handleTimeout ( void );

   //! respone to dia_setAudioTestTone
   virtual void vOnTestTone ( tDiaResult success );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

};


#endif /* DIA_IOCTRLAUDIOTESTTONE_H_ */
