/*
 * dia_IOCtrlAudioSourceSet.h
 *
 *  Created on: 30.11.2012
 *      Author: gib2hi
 */
/*
 * The system implements audioFader to provide the diagnostic tester the ability to control the audio fader.
 * This IOControl will only be accepted if the IOControl remoteControl is currently active.
 */

#ifndef __INCLUDED_DIA_IOCTRL_AUDIO_SOURCE_SET__
#define __INCLUDED_DIA_IOCTRL_AUDIO_SOURCE_SET__

#ifndef __INCLUDED_DIA_IOCTRL_SIGNAL_RESTRICTED_TO_REMOTE_CONTROL__
#include "common/framework/protocols/uds/ioctrl/dia_IOCtrlSignalRestrictedToRemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_AUDIO_MANAGER__
#include <common/framework/platform/cmd/dia_AudioManager.h>
#endif
#ifdef __DIA_NEW_AUDIO_SOURCE_SWITCHING_FSM__

#ifndef __INCLUDED_DIA_AUDIO_MANAGER_CLIENT__
#include <common/framework/platform/cmd/dia_AudioManagerClient.h>
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlAudioSourceSet
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia::AudioManagerClient
{
public:
   //! class constructor
   dia_IOCtrlAudioSourceSet ( void );
   //! class destructor
   virtual ~dia_IOCtrlAudioSourceSet ( void );

   //! perform the short term adjustment of the ioctrl
   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! handle timeout and return control to ECU
   virtual void handleTimeout ( void );

   //! return the requested audio source
   dia_eAudioSource getRequestedAudioSource ( void ) const { return mRequestedAudioSource; }

   //! notification from dia::AudioManager about the result of the audio source switch request
   virtual void onAudioSourceSetResult ( dia_eAudioSource sourceID, tDiaResult resultCode );


protected:
   //! terminate the ioctrl and return control to ECU
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   //! validate incoming data for proper length and format
   virtual tDiaResult validateCtrlValue ( const std::vector<tU8>* pCtrlValue );

   //! diagnosis internal audio source ID
   dia_eAudioSource mRequestedAudioSource;
};

#else

#ifndef __INCLUDED_DIA_IAUDIO_SOURCE_LISTENER__
#include <common/interfaces/dia_IAudioSourceListener.h>
#endif

////////////////////////////////////////////////////////////////////////////////
//
//
//
////////////////////////////////////////////////////////////////////////////////

class dia_IOCtrlAudioSourceSet
   : public dia_IOCtrlSignalRestrictedToRemoteControl,
     public dia_IAudioSourceListenerImpl
{
public:
   //! class constructor
   dia_IOCtrlAudioSourceSet ( void );
   //! class destructor
   virtual ~dia_IOCtrlAudioSourceSet ( void );

   virtual tDiaResult handleRequest ( tU8 timerValue, std::vector<tU8>* ctrlValue );
   //! sends set new source when all needed information are available
   void sendSetSourceWhenReady();
   //!
   virtual void handleTimeout ( void );

   //! response to setAudioSource
   virtual void vOnAudioSourceConnectionDone ( tDiaResult res );
   //! response to getAudioSourceList
   virtual void vOnAudioSourceList ( const std::vector<dia_tAudioSourceType>& audioSrcList );
   //! response to getAudioSourceList
   virtual void vOnAudioSinkList ( const std::vector<dia_tAudioSinkType>& audioSrcList );

protected:
   //! switch off the test screen
   virtual tDiaResult vOnTerminate ( dia_eIOCtrlStatus status );

   dia_eAudioSource     mAudSource;
   dia_tAudioSourceType mAudSourceID;
   tBool                mAudSourceReady;
   dia_eAudioSink       mAudSink;
   dia_tAudioSinkType   mAudSinkID;
   tBool                mAudSinkReady;
};

#endif

#endif /* __INCLUDED_DIA_IOCTRL_AUDIO_SOURCE_SET__ */
